/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.rangedifferencer;

import java.util.ArrayList;
import org.eclipse.compare.internal.LCS;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;

public class RangeComparatorLCS
extends LCS {
    private final IRangeComparator comparator1;
    private final IRangeComparator comparator2;
    private int[][] lcs;

    public static RangeDifference[] findDifferences(IRangeComparator left, IRangeComparator right) {
        RangeComparatorLCS lcs = new RangeComparatorLCS(left, right);
        lcs.longestCommonSubsequence();
        return lcs.getDifferences();
    }

    public RangeComparatorLCS(IRangeComparator comparator1, IRangeComparator comparator2) {
        this.comparator1 = comparator1;
        this.comparator2 = comparator2;
    }

    @Override
    protected int getLength1() {
        return this.comparator1.getRangeCount();
    }

    @Override
    protected int getLength2() {
        return this.comparator2.getRangeCount();
    }

    @Override
    protected void initializeLcs(int lcsLength) {
        this.lcs = new int[2][lcsLength];
    }

    @Override
    protected boolean isRangeEqual(int i1, int i2) {
        return this.comparator1.rangesEqual(i1, this.comparator2, i2);
    }

    @Override
    protected void setLcs(int sl1, int sl2) {
        this.lcs[0][sl1] = sl1 + 1;
        this.lcs[1][sl1] = sl2 + 1;
    }

    public RangeDifference[] getDifferences() {
        ArrayList<RangeDifference> differences = new ArrayList<RangeDifference>();
        int length = this.getLength();
        if (length == 0) {
            differences.add(new RangeDifference(2, 0, this.comparator2.getRangeCount(), 0, this.comparator1.getRangeCount()));
        } else {
            int index2 = 0;
            int s1 = -1;
            int s2 = -1;
            for (int index1 = 0; index1 < this.lcs[0].length && index2 < this.lcs[1].length; ++index1, ++index2) {
                int l2;
                int l1;
                while ((l1 = this.lcs[0][index1]) == 0 && ++index1 < this.lcs[0].length) {
                }
                if (index1 >= this.lcs[0].length) break;
                while ((l2 = this.lcs[1][index2]) == 0 && ++index2 < this.lcs[1].length) {
                }
                if (index2 >= this.lcs[1].length) break;
                int end1 = l1 - 1;
                int end2 = l2 - 1;
                if (s1 == -1 && (end1 != 0 || end2 != 0)) {
                    differences.add(new RangeDifference(2, 0, end2, 0, end1));
                } else if (end1 != s1 + 1 || end2 != s2 + 1) {
                    int leftStart = s1 + 1;
                    int leftLength = end1 - leftStart;
                    int rightStart = s2 + 1;
                    int rightLength = end2 - rightStart;
                    differences.add(new RangeDifference(2, rightStart, rightLength, leftStart, leftLength));
                }
                s1 = end1;
                s2 = end2;
            }
            if (s1 != -1 && (s1 + 1 < this.comparator1.getRangeCount() || s2 + 1 < this.comparator2.getRangeCount())) {
                int leftStart = s1 < this.comparator1.getRangeCount() ? s1 + 1 : s1;
                int rightStart = s2 < this.comparator2.getRangeCount() ? s2 + 1 : s2;
                differences.add(new RangeDifference(2, rightStart, this.comparator2.getRangeCount() - (s2 + 1), leftStart, this.comparator1.getRangeCount() - (s1 + 1)));
            }
        }
        return differences.toArray(new RangeDifference[differences.size()]);
    }

    private void compactAndShiftLCS(int[] lcsSide, int length, IRangeComparator comparator) {
        int i;
        if (length == 0) {
            return;
        }
        int j = 0;
        while (lcsSide[j] == 0) {
            ++j;
        }
        lcsSide[0] = lcsSide[j];
        ++j;
        for (i = 1; i < length; ++i) {
            while (lcsSide[j] == 0) {
                ++j;
            }
            int nextLine = lcsSide[i - 1] + 1;
            lcsSide[i] = nextLine != lcsSide[j] && comparator.rangesEqual(nextLine - 1, comparator, lcsSide[j] - 1) ? nextLine : lcsSide[j];
            ++j;
        }
        for (i = length; i < lcsSide.length; ++i) {
            lcsSide[i] = 0;
        }
    }

    @Override
    public void longestCommonSubsequence() {
        super.longestCommonSubsequence();
        if (this.lcs != null) {
            this.compactAndShiftLCS(this.lcs[0], this.getLength(), this.comparator1);
            this.compactAndShiftLCS(this.lcs[1], this.getLength(), this.comparator2);
        }
    }
}

