/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.LookAndFeelManager;
import org.jmeld.util.prefs.WindowPreference;

public class JMeld
implements Runnable {
    private List<String> fileNameList = new ArrayList<String>();
    private static JMeldPanel jmeldPanel;

    public JMeld(String[] args) {
        for (String arg : args) {
            this.fileNameList.add(arg);
        }
    }

    public static JMeldPanel getJMeldPanel() {
        return jmeldPanel;
    }

    @Override
    public void run() {
        LookAndFeelManager.getInstance().install();
        JFrame frame = new JFrame("JMeld");
        jmeldPanel = new JMeldPanel();
        frame.add(jmeldPanel);
        frame.setDefaultCloseOperation(0);
        frame.setIconImage(ImageUtil.getImageIcon("jmeld-small").getImage());
        new WindowPreference(frame.getTitle(), frame);
        frame.addWindowListener(jmeldPanel.getWindowListener());
        frame.setVisible(true);
        frame.toFront();
        jmeldPanel.openComparison(this.fileNameList);
    }

    public static void main(String[] args) {
        JMeldSettings settings = JMeldSettings.getInstance();
        settings.getEditor().setShowLineNumbers(true);
        settings.setDrawCurves(true);
        settings.setCurveType(1);
        if (settings.getEditor().isAntialiasEnabled()) {
            System.setProperty("swing.aatext", "true");
        }
        SwingUtilities.invokeLater(new JMeld(args));
    }
}

