/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.diff;

import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.jmeld.JMeldException;
import org.jmeld.diff.AbstractJMDiffAlgorithm;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;

public class EclipseDiff
extends AbstractJMDiffAlgorithm {
    @Override
    public JMRevision diff(Object[] orig, Object[] rev) throws JMeldException {
        RangeDifference[] differences = RangeDifferencer.findDifferences(new RangeComparator(orig), new RangeComparator(rev));
        return this.buildRevision(differences, orig, rev);
    }

    private JMRevision buildRevision(RangeDifference[] differences, Object[] orig, Object[] rev) {
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        JMRevision result = new JMRevision(orig, rev);
        for (RangeDifference rd : differences) {
            result.add(new JMDelta(new JMChunk(rd.leftStart(), rd.leftLength()), new JMChunk(rd.rightStart(), rd.rightLength())));
        }
        return result;
    }

    private class RangeComparator
    implements IRangeComparator {
        private Object[] objectArray;

        RangeComparator(Object[] objectArray) {
            this.objectArray = objectArray;
        }

        @Override
        public int getRangeCount() {
            return this.objectArray.length;
        }

        @Override
        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            Object o1 = this.objectArray[thisIndex];
            Object o2 = ((RangeComparator)other).objectArray[otherIndex];
            if (o1 == o2) {
                return true;
            }
            if (o1 == null && o2 != null) {
                return false;
            }
            if (o1 != null && o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        @Override
        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }
    }
}

