/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.diff;

import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMRevision;
import org.jmeld.diff.TypeDiff;

public class JMDelta {
    private static boolean debug = false;
    private JMChunk original;
    private JMChunk revised;
    private TypeDiff type;
    private JMRevision revision;
    private JMRevision changeRevision;

    public JMDelta(JMChunk original, JMChunk revised) {
        this.original = original;
        this.revised = revised;
        this.initType();
    }

    public void setRevision(JMRevision revision) {
        this.revision = revision;
    }

    public JMChunk getOriginal() {
        return this.original;
    }

    public JMChunk getRevised() {
        return this.revised;
    }

    public boolean isAdd() {
        return this.type == TypeDiff.ADD;
    }

    public boolean isDelete() {
        return this.type == TypeDiff.DELETE;
    }

    public boolean isChange() {
        return this.type == TypeDiff.CHANGE;
    }

    public void invalidateChangeRevision() {
        this.setChangeRevision(null);
    }

    public void setChangeRevision(JMRevision changeRevision) {
        this.changeRevision = changeRevision;
    }

    public JMRevision getChangeRevision() {
        if (this.changeRevision == null) {
            this.changeRevision = this.createChangeRevision();
        }
        return this.changeRevision;
    }

    private JMRevision createChangeRevision() {
        return this.revision.createChangeRevision(this.original, this.revised, true);
    }

    void initType() {
        this.type = this.original.getSize() > 0 && this.revised.getSize() == 0 ? TypeDiff.DELETE : (this.original.getSize() == 0 && this.revised.getSize() > 0 ? TypeDiff.ADD : TypeDiff.CHANGE);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JMDelta)) {
            return false;
        }
        JMDelta d = (JMDelta)o;
        if (this.revision != d.revision) {
            return false;
        }
        return this.original.equals(d.original) && this.revised.equals(d.revised);
    }

    private void debug(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    public TypeDiff getType() {
        return this.type;
    }

    public String toString() {
        return this.type + ": org[" + this.original + "] rev[" + this.revised + "]";
    }
}

