/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.ui.util.Colors;

public class LevenshteinTableModel
extends DefaultTableModel {
    String origin;
    String destiny;
    private JMRevision currentRevision;
    private FilePanel[] filePanels;
    private HashMap<Point, Color> routeDiff;
    private HashMap<Point, MatteBorder> borderChunks;
    private HashMap<Point, MatteBorder> borderSelections;
    private boolean showSelectionPath;

    public void buildModel() {
        if (!this.isAllDataAvaliable()) {
            return;
        }
        this.borderSelections = new HashMap();
        this.setDataVector(this.newVector(this.origin.length() + 2), this.newVector(this.destiny.length() + 2));
        this.buildSolutionPath();
        int rowCount = this.getRowCount();
        int columnCount = this.getColumnCount();
        for (int columna = 0; columna < columnCount; ++columna) {
            if (columna < 2) {
                this.setValueAt("", 0, columna);
                continue;
            }
            this.setValueAt(Character.valueOf(this.destiny.charAt(columna - 2)), 0, columna);
        }
        for (int fila = 0; fila < rowCount; ++fila) {
            if (fila < 2) {
                this.setValueAt("", fila, 0);
                continue;
            }
            this.setValueAt(Character.valueOf(this.origin.charAt(fila - 2)), fila, 0);
        }
        int minLength = rowCount > columnCount ? columnCount : rowCount;
        for (int diagonal = 1; diagonal < minLength; ++diagonal) {
            if (diagonal == 1) {
                this.setValueAt(0, diagonal, diagonal);
            } else {
                Object o = this.getValueAt(diagonal - 1, diagonal - 1);
                int incremento = this.origin.charAt(diagonal - 2) == this.destiny.charAt(diagonal - 2) ? 0 : 1;
                this.setValueAt((Integer)o + incremento, diagonal, diagonal);
            }
            for (int columna = diagonal + 1; columna < columnCount; ++columna) {
                this.setValueAt((Integer)this.getValueAt(diagonal, columna - 1) + 1, diagonal, columna);
            }
            for (int fila = diagonal + 1; fila < rowCount; ++fila) {
                this.setValueAt((Integer)this.getValueAt(fila - 1, diagonal) + 1, fila, diagonal);
            }
        }
    }

    private boolean isAllDataAvaliable() {
        return this.getFilePanels() != null && this.getCurrentRevision() != null && this.origin != null && this.destiny != null;
    }

    private void buildSolutionPath() {
        BufferDocumentIF originalBufferDocument = this.filePanels[0].getBufferDocument();
        BufferDocumentIF revisedBufferDocument = this.filePanels[2].getBufferDocument();
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        this.routeDiff = new HashMap();
        this.borderChunks = new HashMap();
        int xOffset = 0;
        int yOffset = 0;
        for (JMDelta next : deltas) {
            int i;
            int lineNumber;
            JMChunk original = next.getOriginal();
            JMChunk revised = next.getRevised();
            int originalLines = originalBufferDocument.getNumberOfLines();
            int revisedLines = revisedBufferDocument.getNumberOfLines();
            int offsetForLineOriginal = original.getAnchor() == originalLines ? originalBufferDocument.getOffsetForLine(original.getAnchor() - 1) + 1 : originalBufferDocument.getOffsetForLine(original.getAnchor());
            int offsetForLineRevised = revised.getAnchor() == revisedLines ? revisedBufferDocument.getOffsetForLine(revised.getAnchor() - 1) + 1 : revisedBufferDocument.getOffsetForLine(revised.getAnchor());
            for (int i2 = 0; i2 < offsetForLineOriginal - xOffset; ++i2) {
                this.routeDiff.put(new Point(i2 + xOffset, i2 + yOffset), Color.GRAY);
            }
            if (next.isAdd()) {
                lineNumber = revised.getAnchor() + revised.getSize() - 1;
                int yOffsetForLineEnd = revisedBufferDocument.getOffsetForLine(lineNumber) + revisedBufferDocument.getLineText(lineNumber).length();
                for (i = 0; i < yOffsetForLineEnd - offsetForLineRevised; ++i) {
                    MatteBorder border = i == 0 ? BorderFactory.createMatteBorder(2, 2, 2, 0, Color.BLACK) : (i == yOffsetForLineEnd - offsetForLineRevised - 1 ? BorderFactory.createMatteBorder(2, 0, 2, 2, Color.BLACK) : BorderFactory.createMatteBorder(2, 0, 2, 0, Color.BLACK));
                    Point point = new Point(offsetForLineOriginal - 1, i + offsetForLineRevised);
                    this.addBorderChunks(point, border);
                    this.routeDiff.put(point, Colors.ADDED);
                }
                xOffset = offsetForLineOriginal;
                yOffset = yOffsetForLineEnd;
                continue;
            }
            if (next.isDelete()) {
                lineNumber = original.getAnchor() + original.getSize() - 1;
                int xOffsetForLine = originalBufferDocument.getOffsetForLine(lineNumber) + originalBufferDocument.getLineText(lineNumber).length();
                for (i = 0; i < xOffsetForLine - offsetForLineOriginal; ++i) {
                    Point point = new Point(i + offsetForLineOriginal, offsetForLineRevised - 1);
                    this.routeDiff.put(point, Colors.DELETED);
                    MatteBorder border = i == 0 ? BorderFactory.createMatteBorder(2, 2, 0, 2, Color.BLACK) : (i == xOffsetForLine - offsetForLineOriginal - 1 ? BorderFactory.createMatteBorder(0, 2, 2, 2, Color.BLACK) : BorderFactory.createMatteBorder(0, 2, 0, 2, Color.BLACK));
                    this.addBorderChunks(point, border);
                }
                xOffset = xOffsetForLine;
                yOffset = offsetForLineRevised;
                continue;
            }
            if (!next.isChange()) continue;
            List<JMDelta> changedDeltas = next.getChangeRevision().getDeltas();
            xOffset = offsetForLineOriginal;
            yOffset = offsetForLineRevised;
            for (JMDelta changeDelta : changedDeltas) {
                MatteBorder border;
                int j;
                Point point;
                int i3;
                JMChunk originalChange = changeDelta.getOriginal();
                JMChunk revisedChange = changeDelta.getRevised();
                int sameChars = originalChange.getAnchor() - xOffset;
                for (int i4 = 0; i4 < sameChars; ++i4) {
                    this.routeDiff.put(new Point(i4 + xOffset, i4 + yOffset), Color.GRAY);
                }
                xOffset += sameChars;
                yOffset += sameChars;
                int removeFromOrigin = originalChange.getSize();
                int addFromRevised = revisedChange.getSize();
                for (i3 = 0; i3 < removeFromOrigin; ++i3) {
                    point = new Point(i3 + xOffset, yOffset - 1);
                    this.routeDiff.put(point, Colors.DELETED);
                    if (i3 == 0) {
                        for (j = 0; j < addFromRevised; ++j) {
                            border = j == addFromRevised - 1 ? BorderFactory.createMatteBorder(2, 0, 0, 2, Color.BLACK) : BorderFactory.createMatteBorder(2, 0, 0, 0, Color.BLACK);
                            this.addBorderChunks(new Point(i3 + xOffset, yOffset + j), border);
                        }
                        border = BorderFactory.createMatteBorder(2, 2, 0, 0, Color.BLACK);
                        this.addBorderChunks(point, border);
                    }
                    if (i3 == removeFromOrigin - 1) {
                        border = BorderFactory.createMatteBorder(0, 2, 2, 0, Color.BLACK);
                    } else {
                        border = BorderFactory.createMatteBorder(0, 0, 0, 2, Color.BLACK);
                        this.addBorderChunks(new Point(i3 + xOffset, yOffset - 1 + addFromRevised), border);
                        border = BorderFactory.createMatteBorder(0, 2, 0, 0, Color.BLACK);
                    }
                    this.addBorderChunks(point, border);
                }
                xOffset += removeFromOrigin;
                if (addFromRevised == 0) {
                    Point point2 = new Point(xOffset - 1, yOffset - 1);
                    MatteBorder border2 = BorderFactory.createMatteBorder(0, 0, 0, 2, Color.BLACK);
                    this.addBorderChunks(point2, border2);
                }
                for (i3 = 0; i3 < addFromRevised; ++i3) {
                    point = new Point(xOffset - 1, i3 + yOffset);
                    this.routeDiff.put(point, Colors.ADDED);
                    if (i3 == 0 && removeFromOrigin == 0) {
                        for (j = 0; j < addFromRevised; ++j) {
                            border = j == addFromRevised - 1 ? BorderFactory.createMatteBorder(2, 0, 0, 2, Color.BLACK) : BorderFactory.createMatteBorder(2, 0, 0, 0, Color.BLACK);
                            this.addBorderChunks(new Point(i3 - 1 + xOffset, yOffset + j), border);
                        }
                        border = BorderFactory.createMatteBorder(2, 2, 0, 0, Color.BLACK);
                        this.addBorderChunks(point, border);
                    }
                    border = i3 == addFromRevised - 1 ? BorderFactory.createMatteBorder(0, 0, 2, 2, Color.BLACK) : BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLACK);
                    this.addBorderChunks(point, border);
                }
                yOffset += addFromRevised;
            }
        }
        int xSize = originalBufferDocument.getDocument().getLength();
        for (int i = 0; i < xSize - xOffset; ++i) {
            this.routeDiff.put(new Point(i + xOffset, i + yOffset), Color.GRAY);
        }
    }

    private void addBorderChunks(Point point, MatteBorder border) {
        MatteBorder oldborder = this.borderChunks.get(point);
        if (oldborder != null) {
            Insets oldborderInsets = oldborder.getBorderInsets();
            Insets borderInsets = border.getBorderInsets();
            if (oldborderInsets.top == 0 && borderInsets.top > 0) {
                oldborderInsets.top = borderInsets.top;
            }
            if (oldborderInsets.left == 0 && borderInsets.left > 0) {
                oldborderInsets.left = borderInsets.left;
            }
            if (oldborderInsets.right == 0 && borderInsets.right > 0) {
                oldborderInsets.right = borderInsets.right;
            }
            if (oldborderInsets.bottom == 0 && borderInsets.bottom > 0) {
                oldborderInsets.bottom = borderInsets.bottom;
            }
            border = BorderFactory.createMatteBorder(oldborderInsets.top, oldborderInsets.left, oldborderInsets.bottom, oldborderInsets.right, border.getMatteColor());
        }
        this.borderChunks.put(point, border);
    }

    private Vector newVector(int size) {
        Vector vector = new Vector(size);
        vector.setSize(size);
        return vector;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        this.buildModel();
    }

    public String getDestiny() {
        return this.destiny;
    }

    public void setDestiny(String destiny) {
        this.destiny = destiny;
        this.buildModel();
    }

    public DefaultTableCellRenderer getCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color color;
                if ("\n".equals(value.toString())) {
                    value = "\\n";
                }
                Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Color background = Color.WHITE;
                if (row < 2 && column < 2) {
                    background = row == column ? Color.GREEN : Color.BLUE;
                } else {
                    if (row > 1 && column > 1 && LevenshteinTableModel.this.origin.charAt(row - 2) == LevenshteinTableModel.this.destiny.charAt(column - 2)) {
                        background = Color.ORANGE;
                    }
                    if (row == 0 || column == 0) {
                        background = new Color(1426102783, true);
                    }
                }
                if (isSelected || table.isColumnSelected(column)) {
                    Color newColor = Color.CYAN;
                    Color mixColor = Color.WHITE;
                    background = new Color(background.getRed() * newColor.getRed() / mixColor.getRed(), background.getGreen() * newColor.getGreen() / mixColor.getGreen(), background.getBlue() * newColor.getBlue() / mixColor.getBlue());
                }
                Point point = new Point(row - 2, column - 2);
                if (LevenshteinTableModel.this.showSelectionPath && (color = LevenshteinTableModel.this.routeDiff.get(point)) != null) {
                    background = color;
                }
                Border border = LevenshteinTableModel.this.borderChunks.get(point);
                Border borderSelection = LevenshteinTableModel.this.borderSelections.get(point);
                if (border == null) {
                    if (borderSelection != null) {
                        border = borderSelection;
                    }
                } else if (borderSelection != null) {
                    border = new CompoundBorder(border, borderSelection);
                }
                if (border != null) {
                    ((JLabel)tableCellRendererComponent).setBorder(border);
                }
                tableCellRendererComponent.setBackground(background);
                ((JLabel)tableCellRendererComponent).setHorizontalAlignment(0);
                return tableCellRendererComponent;
            }
        };
    }

    public void setCurrentRevision(JMRevision currentRevision) {
        this.currentRevision = currentRevision;
        this.buildModel();
    }

    public JMRevision getCurrentRevision() {
        return this.currentRevision;
    }

    public void setFilePanels(FilePanel[] filePanels) {
        this.filePanels = filePanels;
        this.buildModel();
    }

    public FilePanel[] getFilePanels() {
        return this.filePanels;
    }

    public boolean isShowSelectionPath() {
        return this.showSelectionPath;
    }

    public void setShowSelectionPath(boolean showSelectionPath) {
        this.showSelectionPath = showSelectionPath;
    }

    public HashMap<Point, MatteBorder> getBorderSelections() {
        return this.borderSelections;
    }

    public void setBorderSelections(HashMap<Point, MatteBorder> borderSelection) {
        this.borderSelections = borderSelection;
    }

    class ColorPoint
    extends Point {
        Color color;

        public ColorPoint(int x, int y, Color color) {
            super(x, y);
            this.color = color;
        }
    }
}

