/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.settings;

import java.awt.Color;
import java.awt.Font;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.jmeld.settings.ColorSetting;
import org.jmeld.settings.FontSetting;
import org.jmeld.ui.util.Colors;
import org.jmeld.util.Ignore;
import org.jmeld.util.ObjectUtil;
import org.jmeld.util.conf.AbstractConfiguration;
import org.jmeld.util.conf.AbstractConfigurationElement;

@XmlAccessorType(value=XmlAccessType.NONE)
public class EditorSettings
extends AbstractConfigurationElement {
    @XmlElement
    private boolean showLineNumbers;
    @XmlElement
    private int tabSize = 4;
    @XmlElement
    private Ignore ignore = new Ignore();
    @XmlElement
    private boolean leftsideReadonly;
    @XmlElement
    private boolean rightsideReadonly;
    @XmlElement
    private ColorSetting addedColor;
    @XmlElement
    private ColorSetting changedColor;
    @XmlElement
    private ColorSetting deletedColor;
    @XmlElement
    private boolean customFont;
    @XmlElement
    private FontSetting font;
    @XmlElement
    private boolean antialias;
    @XmlElement
    private boolean defaultFileEncodingEnabled = true;
    @XmlElement
    private boolean detectFileEncodingEnabled;
    @XmlElement
    private boolean specificFileEncodingEnabled;
    @XmlElement
    private String specificFileEncodingName;
    @XmlElement
    private String lookAndFeelName;
    @XmlElement
    private ToolbarButtonIcon toolbarButtonIcon = ToolbarButtonIcon.LARGE;
    @XmlElement
    private String typeTokenizerName = "word";
    @XmlElement
    private boolean toolbarButtonTextEnabled = true;
    @XmlElement
    private boolean showLevenstheinEditor;
    @XmlElement
    private boolean showTreeChunks;
    @XmlElement
    private boolean showTreeRaw;

    @Override
    public void init(AbstractConfiguration configuration) {
        super.init(configuration);
        this.ignore.init(configuration);
    }

    public boolean getShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        if (showLineNumbers == this.showLineNumbers) {
            return;
        }
        this.showLineNumbers = showLineNumbers;
        this.fireChanged();
    }

    public boolean isShowLevenstheinEditor() {
        return this.showLevenstheinEditor;
    }

    public void setShowLevenstheinEditor(boolean showLevenstheinEditor) {
        if (showLevenstheinEditor == this.showLevenstheinEditor) {
            return;
        }
        this.showLevenstheinEditor = showLevenstheinEditor;
        this.fireChanged();
    }

    public boolean isShowTreeChunks() {
        return this.showTreeChunks;
    }

    public void setShowTreeChunks(boolean showTreeChunks) {
        if (showTreeChunks == this.showTreeChunks) {
            return;
        }
        this.showTreeChunks = showTreeChunks;
        this.fireChanged();
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int tabSize) {
        if (tabSize == this.tabSize) {
            return;
        }
        this.tabSize = tabSize;
        this.fireChanged();
    }

    public Ignore getIgnore() {
        return this.ignore;
    }

    public void setIgnoreWhitespaceAtBegin(boolean ignoreWhitespaceAtBegin) {
        if (this.getIgnore().ignoreWhitespaceAtBegin == ignoreWhitespaceAtBegin) {
            return;
        }
        this.getIgnore().ignoreWhitespaceAtBegin = ignoreWhitespaceAtBegin;
        this.fireChanged();
    }

    public void setIgnoreWhitespaceInBetween(boolean ignoreWhitespaceInBetween) {
        if (this.getIgnore().ignoreWhitespaceInBetween == ignoreWhitespaceInBetween) {
            return;
        }
        this.getIgnore().ignoreWhitespaceInBetween = ignoreWhitespaceInBetween;
        this.fireChanged();
    }

    public void setIgnoreWhitespaceAtEnd(boolean ignoreWhitespaceAtEnd) {
        if (this.getIgnore().ignoreWhitespaceAtEnd == ignoreWhitespaceAtEnd) {
            return;
        }
        this.getIgnore().ignoreWhitespaceAtEnd = ignoreWhitespaceAtEnd;
        this.fireChanged();
    }

    public void setIgnoreEOL(boolean ignoreEOL) {
        if (this.getIgnore().ignoreEOL == ignoreEOL) {
            return;
        }
        this.getIgnore().ignoreEOL = ignoreEOL;
        this.fireChanged();
    }

    public void setIgnoreBlankLines(boolean ignoreBlankLines) {
        if (this.getIgnore().ignoreBlankLines == ignoreBlankLines) {
            return;
        }
        this.getIgnore().ignoreBlankLines = ignoreBlankLines;
        this.fireChanged();
    }

    public void setIgnoreCase(boolean ignoreCase) {
        if (this.getIgnore().ignoreCase == ignoreCase) {
            return;
        }
        this.getIgnore().ignoreCase = ignoreCase;
        this.fireChanged();
    }

    public boolean getLeftsideReadonly() {
        return this.leftsideReadonly;
    }

    public void setLeftsideReadonly(boolean leftsideReadonly) {
        if (this.leftsideReadonly == leftsideReadonly) {
            return;
        }
        this.leftsideReadonly = leftsideReadonly;
        this.fireChanged();
    }

    public boolean getRightsideReadonly() {
        return this.rightsideReadonly;
    }

    public void setRightsideReadonly(boolean rightsideReadonly) {
        if (this.rightsideReadonly == rightsideReadonly) {
            return;
        }
        this.rightsideReadonly = rightsideReadonly;
        this.fireChanged();
    }

    public boolean getDefaultFileEncodingEnabled() {
        return this.defaultFileEncodingEnabled;
    }

    public void setDefaultFileEncodingEnabled(boolean encoding) {
        if (this.defaultFileEncodingEnabled == encoding) {
            return;
        }
        this.defaultFileEncodingEnabled = encoding;
        this.fireChanged();
    }

    public boolean getDetectFileEncodingEnabled() {
        return this.detectFileEncodingEnabled;
    }

    public void setDetectFileEncodingEnabled(boolean encoding) {
        if (this.detectFileEncodingEnabled == encoding) {
            return;
        }
        this.detectFileEncodingEnabled = encoding;
        this.fireChanged();
    }

    public boolean getSpecificFileEncodingEnabled() {
        return this.specificFileEncodingEnabled;
    }

    public void setSpecificFileEncodingEnabled(boolean encoding) {
        if (this.specificFileEncodingEnabled == encoding) {
            return;
        }
        this.specificFileEncodingEnabled = encoding;
        this.fireChanged();
    }

    public String getSpecificFileEncodingName() {
        return this.specificFileEncodingName;
    }

    public void setSpecificFileEncodingName(String encodingName) {
        if (ObjectUtil.equals(this.specificFileEncodingName, encodingName)) {
            return;
        }
        this.specificFileEncodingName = encodingName;
        this.fireChanged();
    }

    public void restoreColors() {
        this.addedColor = null;
        this.changedColor = null;
        this.deletedColor = null;
        this.fireChanged();
    }

    public void setAddedColor(Color color) {
        this.addedColor = new ColorSetting(color);
        this.fireChanged();
    }

    public Color getAddedColor() {
        return this.getColor(this.addedColor, Colors.ADDED);
    }

    public void setChangedColor(Color color) {
        this.changedColor = new ColorSetting(color);
        this.fireChanged();
    }

    public Color getChangedColor() {
        return this.getColor(this.changedColor, Colors.CHANGED);
    }

    public void setDeletedColor(Color color) {
        this.deletedColor = new ColorSetting(color);
        this.fireChanged();
    }

    public Color getDeletedColor() {
        return this.getColor(this.deletedColor, Colors.DELETED);
    }

    public void setLookAndFeelName(String lookAndFeelName) {
        this.lookAndFeelName = lookAndFeelName;
        this.fireChanged();
    }

    public String getLookAndFeelName() {
        return this.lookAndFeelName;
    }

    public void setToolbarButtonIcon(ToolbarButtonIcon toolbarButtonIcon) {
        if (this.toolbarButtonIcon == toolbarButtonIcon) {
            return;
        }
        this.toolbarButtonIcon = toolbarButtonIcon;
        if (toolbarButtonIcon == ToolbarButtonIcon.NO) {
            this.toolbarButtonTextEnabled = true;
        }
        this.fireChanged();
    }

    public void setTypeTokenizerName(String typeTokenizerName) {
        if (this.typeTokenizerName.equals(typeTokenizerName)) {
            return;
        }
        this.typeTokenizerName = typeTokenizerName;
        this.fireChanged();
    }

    public ToolbarButtonIcon getToolbarButtonIcon() {
        return this.toolbarButtonIcon;
    }

    public String getTypeTokenizerName() {
        return this.typeTokenizerName;
    }

    public void setToolbarButtonTextEnabled(boolean toolbarButtonTextEnabled) {
        if (this.toolbarButtonTextEnabled == toolbarButtonTextEnabled) {
            return;
        }
        this.toolbarButtonTextEnabled = toolbarButtonTextEnabled;
        if (!toolbarButtonTextEnabled && this.toolbarButtonIcon == ToolbarButtonIcon.NO) {
            this.toolbarButtonIcon = ToolbarButtonIcon.LARGE;
        }
        this.fireChanged();
    }

    public ToolbarButtonIcon[] getToolbarButtonIcons() {
        return ToolbarButtonIcon.values();
    }

    public boolean isToolbarButtonTextEnabled() {
        return this.toolbarButtonTextEnabled;
    }

    public void enableCustomFont(boolean customFont) {
        this.customFont = customFont;
        this.fireChanged();
    }

    public boolean isCustomFontEnabled() {
        return this.customFont;
    }

    public void enableAntialias(boolean antialias) {
        this.antialias = antialias;
        this.fireChanged();
    }

    public boolean isAntialiasEnabled() {
        return this.antialias;
    }

    public void setFont(Font f) {
        this.font = new FontSetting(f);
        this.fireChanged();
    }

    public Font getFont() {
        return this.font == null ? null : this.font.getFont();
    }

    private Color getColor(ColorSetting cc, Color defaultColor) {
        Color c = null;
        if (cc != null) {
            c = cc.getColor();
        }
        if (c == null) {
            c = defaultColor;
        }
        return c;
    }

    public boolean isShowTreeRaw() {
        return this.showTreeRaw;
    }

    public void setShowTreeRaw(boolean showTreeRaw) {
        this.showTreeRaw = showTreeRaw;
        this.fireChanged();
    }

    public static enum ToolbarButtonIcon {
        NO("no icon"),
        SMALL("small icon"),
        LARGE("large icon");

        private String text;

        private ToolbarButtonIcon(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

