/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import javax.swing.JPanel;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.jmeld.ui.JMeldContentPanelIF;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.util.ObjectUtil;

public class AbstractContentPanel
extends JPanel
implements JMeldContentPanelIF {
    private MyUndoManager undoManager = new MyUndoManager();
    private String id;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isSaveEnabled() {
        return false;
    }

    @Override
    public void doSave() {
    }

    @Override
    public boolean checkSave() {
        return true;
    }

    @Override
    public boolean isUndoEnabled() {
        return this.getUndoHandler().canUndo();
    }

    @Override
    public void doUndo() {
        try {
            if (this.getUndoHandler().canUndo()) {
                this.getUndoHandler().undo();
            }
        }
        catch (CannotUndoException ex) {
            System.out.println("Unable to undo: " + ex);
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isRedoEnabled() {
        return this.getUndoHandler().canRedo();
    }

    @Override
    public void doRedo() {
        try {
            if (this.getUndoHandler().canRedo()) {
                this.getUndoHandler().redo();
            }
        }
        catch (CannotUndoException ex) {
            System.out.println("Unable to undo: " + ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void doLeft(boolean shift) {
    }

    @Override
    public void doRight(boolean shift) {
    }

    @Override
    public void doUp() {
    }

    @Override
    public void doDown() {
    }

    @Override
    public void doZoom(boolean direction) {
    }

    @Override
    public void doGoToSelected() {
    }

    @Override
    public void doGoToFirst() {
    }

    @Override
    public void doGoToLast() {
    }

    @Override
    public void doGoToLine(int line) {
    }

    @Override
    public void doStopSearch() {
    }

    @Override
    public SearchHits doSearch() {
        return null;
    }

    @Override
    public void doNextSearch() {
    }

    @Override
    public void doPreviousSearch() {
    }

    @Override
    public void doRefresh() {
    }

    @Override
    public void doMergeMode(boolean mergeMode) {
    }

    @Override
    public boolean checkExit() {
        return true;
    }

    public MyUndoManager getUndoHandler() {
        return this.undoManager;
    }

    public void checkActions() {
    }

    @Override
    public String getSelectedText() {
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractContentPanel)) {
            return false;
        }
        return ObjectUtil.equals(((AbstractContentPanel)o).getId(), this.id);
    }

    public class MyUndoManager
    extends UndoManager
    implements UndoableEditListener {
        CompoundEdit activeEdit;

        private MyUndoManager() {
        }

        public void start(String text) {
            this.activeEdit = new CompoundEdit();
        }

        public void add(UndoableEdit edit) {
            this.addEdit(edit);
        }

        public void end(String text) {
            this.activeEdit.end();
            this.addEdit(this.activeEdit);
            this.activeEdit = null;
            AbstractContentPanel.this.checkActions();
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (this.activeEdit != null) {
                this.activeEdit.addEdit(e.getEdit());
                return;
            }
            this.addEdit(e.getEdit());
            AbstractContentPanel.this.checkActions();
        }
    }
}

