/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jmeld.JMeldException;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMDiff;
import org.jmeld.diff.JMRevision;
import org.jmeld.model.LevenshteinTableModel;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.RevisionBar;
import org.jmeld.ui.SavePanelDialog;
import org.jmeld.ui.ScrollSynchronizer;
import org.jmeld.ui.diffbar.DiffScrollComponent;
import org.jmeld.ui.search.SearchCommand;
import org.jmeld.ui.search.SearchHit;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.text.AbstractBufferDocument;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.ui.text.JMDocumentEvent;
import org.jmeld.ui.tree.DiffTree;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.JMDiffNode;

public class BufferDiffPanel
extends AbstractContentPanel
implements ConfigurationListenerIF {
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int RIGHT = 2;
    public static final int NUMBER_OF_PANELS = 3;
    private JMeldPanel mainPanel;
    private FilePanel[] filePanels;
    private JMDiffNode diffNode;
    int filePanelSelectedIndex = -1;
    private JMRevision currentRevision;
    private JMDelta selectedDelta;
    private int selectedLine;
    private ScrollSynchronizer scrollSynchronizer;
    private JMDiff diff;
    private JTable levensteinGraphTable;
    private DiffTree diffTree;
    private boolean showTree;
    private boolean showLevenstein;
    private JSplitPane splitPane;
    private JCheckBox checkSolutionPath;
    static Color selectionColor = Color.BLUE;
    static Color newColor = Color.CYAN;
    static Color mixColor = Color.WHITE;

    BufferDiffPanel(JMeldPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.readConfig();
        JMeldSettings.getInstance().addConfigurationListener(this);
        this.diff = new JMDiff();
        this.init();
        this.setFocusable(true);
    }

    public boolean isShowTree() {
        return this.showTree;
    }

    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    public boolean isShowLevenstein() {
        return this.showLevenstein;
    }

    public void setShowLevenstein(boolean showLevenstein) {
        this.showLevenstein = showLevenstein;
    }

    public void setDiffNode(JMDiffNode diffNode) {
        this.diffNode = diffNode;
        this.refreshDiffNode();
    }

    public JMDiffNode getDiffNode() {
        return this.diffNode;
    }

    private void refreshDiffNode() {
        BufferNode bnLeft = this.getDiffNode().getBufferNodeLeft();
        BufferNode bnRight = this.getDiffNode().getBufferNodeRight();
        BufferDocumentIF leftDocument = bnLeft == null ? null : bnLeft.getDocument();
        BufferDocumentIF rightDocument = bnRight == null ? null : bnRight.getDocument();
        this.setBufferDocuments(leftDocument, rightDocument, this.getDiffNode().getDiff(), this.getDiffNode().getRevision());
    }

    private void setBufferDocuments(BufferDocumentIF bd1, BufferDocumentIF bd2, JMDiff diff, JMRevision revision) {
        this.diff = diff;
        this.currentRevision = revision;
        if (bd1 != null) {
            this.filePanels[0].setBufferDocument(bd1);
        }
        if (bd2 != null) {
            this.filePanels[2].setBufferDocument(bd2);
        }
        if (bd1 != null && bd2 != null) {
            this.filePanels[0].updateFileLabel(bd1.getName(), bd2.getName());
            this.filePanels[2].updateFileLabel(bd2.getName(), bd1.getName());
        }
        if (bd1 != null && bd2 != null) {
            this.reDisplay();
        }
    }

    private void reDisplay() {
        for (FilePanel fp : this.filePanels) {
            if (fp == null) continue;
            fp.reDisplay();
        }
        this.refreshTreeModel();
        this.refreshLevensteinModel();
        this.mainPanel.repaint();
    }

    private void refreshTreeModel() {
        if (this.isShowTree()) {
            this.diffTree.setRevision(this.getCurrentRevision());
        }
    }

    public String getTitle() {
        Object title = "";
        ArrayList<String> titles = new ArrayList<String>();
        for (FilePanel filePanel : this.filePanels) {
            BufferDocumentIF bd;
            if (filePanel == null || (bd = filePanel.getBufferDocument()) == null) continue;
            title = bd.getShortName();
            titles.add((String)title);
        }
        title = "";
        title = titles.size() == 1 ? (String)titles.get(0) : (((String)titles.get(0)).equals(titles.get(1)) ? (String)titles.get(0) : (String)titles.get(0) + "-" + (String)titles.get(1));
        return title;
    }

    public boolean revisionChanged(JMDocumentEvent de) {
        if (this.currentRevision == null) {
            this.diff();
        } else {
            BufferDocumentIF bd2;
            FilePanel fp = this.getFilePanel(de.getDocument());
            if (fp == null) {
                return false;
            }
            BufferDocumentIF bd1 = this.filePanels[0].getBufferDocument();
            if (!this.currentRevision.update(bd1 != null ? bd1.getLines() : null, (bd2 = this.filePanels[2].getBufferDocument()) != null ? bd2.getLines() : null, fp == this.filePanels[0], de.getStartLine(), de.getNumberOfLines())) {
                return false;
            }
            this.reDisplay();
        }
        return true;
    }

    private FilePanel getFilePanel(AbstractBufferDocument document) {
        for (FilePanel fp : this.filePanels) {
            if (fp == null || fp.getBufferDocument() != document) continue;
            return fp;
        }
        return null;
    }

    public void diff() {
        BufferDocumentIF bd1 = this.filePanels[0].getBufferDocument();
        BufferDocumentIF bd2 = this.filePanels[2].getBufferDocument();
        if (bd1 != null && bd2 != null) {
            try {
                this.currentRevision = this.diff.diff(bd1.getLines(), bd2.getLines(), this.getDiffNode().getIgnore());
                this.reDisplay();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void init() {
        String columns = "3px, pref, 3px, 0:grow, 5px, min, 60px, 0:grow, 25px, min, 3px, pref, 3px";
        String rows = "6px, pref, 3px, fill:0:grow, pref";
        this.setLayout(new BorderLayout());
        if (this.splitPane != null) {
            this.remove(this.splitPane);
        }
        this.splitPane = new JSplitPane(0, true, this.buildFilePanel(columns, rows), this.buildBottonSplit());
        this.add(this.splitPane);
        this.scrollSynchronizer = new ScrollSynchronizer(this, this.filePanels[0], this.filePanels[2]);
        this.setSelectedPanel(this.filePanels[0]);
    }

    private JComponent buildBottonSplit() {
        JScrollPane scrollTreePane = this.buildTreePane();
        JComponent levensteinPanel = this.buildLevenstheinTable();
        JComponent bottomSplit = scrollTreePane != null ? (levensteinPanel != null ? new JSplitPane(1, true, scrollTreePane, levensteinPanel) : scrollTreePane) : levensteinPanel;
        return bottomSplit;
    }

    private JPanel buildFilePanel(String columns, String rows) {
        JPanel filePanel = new JPanel();
        FormLayout layout = new FormLayout(columns, rows);
        CellConstraints cc = new CellConstraints();
        filePanel.setLayout(layout);
        this.filePanels = new FilePanel[3];
        this.filePanels[0] = new FilePanel(this, "Original", 0);
        this.filePanels[2] = new FilePanel(this, "Revised", 2);
        filePanel.add((Component)new RevisionBar(this, this.filePanels[0], true), cc.xy(2, 4));
        if (this.mainPanel.SHOW_FILE_SAVE_BAR_OPTION.isEnabled()) {
            filePanel.add((Component)this.filePanels[0].getSaveButton(), cc.xy(2, 2));
        }
        if (this.mainPanel.SHOW_FILE_LABEL_OPTION.isEnabled()) {
            filePanel.add((Component)this.filePanels[0].getFileLabel(), cc.xyw(4, 2, 3));
        }
        filePanel.add((Component)this.filePanels[0].getScrollPane(), cc.xyw(4, 4, 3));
        if (this.mainPanel.SHOW_FILE_STATUSBAR_OPTION.isEnabled()) {
            filePanel.add((Component)this.filePanels[0].getFilePanelBar(), cc.xyw(4, 5, 3));
        }
        DiffScrollComponent diffScrollComponent = new DiffScrollComponent(this, 0, 2);
        filePanel.add((Component)diffScrollComponent, cc.xy(7, 4));
        filePanel.add((Component)new RevisionBar(this, this.filePanels[2], false), cc.xy(12, 4));
        if (this.mainPanel.SHOW_FILE_LABEL_OPTION.isEnabled()) {
            filePanel.add((Component)this.filePanels[2].getFileLabel(), cc.xyw(8, 2, 3));
        }
        filePanel.add((Component)this.filePanels[2].getScrollPane(), cc.xyw(8, 4, 3));
        if (this.mainPanel.SHOW_FILE_SAVE_BAR_OPTION.isEnabled()) {
            filePanel.add((Component)this.filePanels[2].getSaveButton(), cc.xy(12, 2));
        }
        if (this.mainPanel.SHOW_FILE_STATUSBAR_OPTION.isEnabled()) {
            filePanel.add((Component)this.filePanels[2].getFilePanelBar(), cc.xyw(8, 5, 3));
        }
        this.filePanels[2].getEditor().addKeyListener(diffScrollComponent.getKeyListener());
        this.filePanels[0].getEditor().addKeyListener(diffScrollComponent.getKeyListener());
        filePanel.setMinimumSize(new Dimension(300, 200));
        return filePanel;
    }

    private JScrollPane buildTreePane() {
        JScrollPane scrollTreePane = null;
        if (this.isShowTree()) {
            scrollTreePane = new JScrollPane();
            this.diffTree = new DiffTree();
            this.diffTree.addMouseListener(new MouseAdapter(){

                private void showPopup(MouseEvent e) {
                    JMenuItem menuItem;
                    int x = e.getX();
                    int y = e.getY();
                    JTree tree = (JTree)e.getSource();
                    TreePath path = tree.getPathForLocation(x, y);
                    if (path == null) {
                        return;
                    }
                    tree.setSelectionPath(path);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = node.getUserObject();
                    JPopupMenu popup = new JPopupMenu();
                    if (userObject instanceof JMDelta) {
                        menuItem = this.buildDeleteItem(userObject);
                        menuItem.setEnabled(this.enableDeleteAction(node));
                        popup.add(menuItem);
                    }
                    if (userObject instanceof JMRevision) {
                        menuItem = this.buildInsertItem();
                        menuItem.setEnabled(this.enableInsertAction(node));
                        popup.add(menuItem);
                    }
                    popup.show(tree, x, y);
                }

                private boolean enableDeleteAction(DefaultMutableTreeNode node) {
                    Object parentUserObject = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
                    return parentUserObject instanceof JMRevision || parentUserObject instanceof JMDelta && ((JMDelta)parentUserObject).isChange();
                }

                private JMenuItem buildDeleteItem(final Object userObject) {
                    JMenuItem menuItem = new JMenuItem("Delete node");
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            List<JMDelta> deltas = BufferDiffPanel.this.currentRevision.getDeltas();
                            for (JMDelta delta : deltas) {
                                if (this.deleteDelta(deltas, delta)) {
                                    return;
                                }
                                if (!delta.isChange()) continue;
                                List<JMDelta> changeDeltas = delta.getChangeRevision().getDeltas();
                                for (JMDelta changeDelta : changeDeltas) {
                                    if (!this.deleteDelta(changeDeltas, changeDelta)) continue;
                                    return;
                                }
                            }
                        }

                        private boolean deleteDelta(List<JMDelta> deltas, JMDelta delta) {
                            if (delta.equals(userObject)) {
                                deltas.remove(delta);
                                BufferDiffPanel.this.reDisplay();
                                return true;
                            }
                            return false;
                        }
                    });
                    return menuItem;
                }

                private JMenuItem buildInsertItem() {
                    JMenuItem menuItem = new JMenuItem("Insert node");
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int selectedRow = BufferDiffPanel.this.levensteinGraphTable.getSelectedRow();
                            int selectedColumn = BufferDiffPanel.this.levensteinGraphTable.getSelectedColumn();
                            int selectedRowCount = BufferDiffPanel.this.levensteinGraphTable.getSelectedRowCount();
                            int selectedColumnCount = BufferDiffPanel.this.levensteinGraphTable.getSelectedColumnCount();
                            if (selectedRowCount == 1) {
                                selectedRowCount = 0;
                            }
                            if (selectedColumnCount == 1) {
                                selectedColumnCount = 0;
                            }
                            try {
                                JMRevision changeRevision;
                                JTextArea leftEditor = BufferDiffPanel.this.filePanels[0].getEditor();
                                int firstLine = leftEditor.getLineOfOffset(selectedRow - 2);
                                int endLine = leftEditor.getLineOfOffset(selectedRow - 2 + selectedRowCount - 1);
                                JMChunk original = new JMChunk(firstLine, endLine - firstLine + 1);
                                JTextArea rightEditor = BufferDiffPanel.this.filePanels[2].getEditor();
                                int firstCol = rightEditor.getLineOfOffset(selectedColumn - 2);
                                int endCol = rightEditor.getLineOfOffset(selectedColumn - 2 + selectedColumnCount - 1);
                                JMChunk revised = new JMChunk(firstCol, endCol - firstCol + 1);
                                JMDelta newDdelta = new JMDelta(original, revised);
                                newDdelta.setRevision(BufferDiffPanel.this.currentRevision);
                                boolean createNew = true;
                                List<JMDelta> deltas = BufferDiffPanel.this.currentRevision.getDeltas();
                                for (int i = 0; i < deltas.size(); ++i) {
                                    JMDelta delta = deltas.get(i);
                                    if (!delta.equals(newDdelta)) continue;
                                    newDdelta = delta;
                                    createNew = false;
                                }
                                if (createNew) {
                                    changeRevision = BufferDiffPanel.this.currentRevision.createChangeRevision(original, revised, false);
                                    newDdelta.setChangeRevision(changeRevision);
                                    deltas.add(newDdelta);
                                } else {
                                    changeRevision = newDdelta.getChangeRevision();
                                }
                                List<JMDelta> changeDeltas = changeRevision.getDeltas();
                                changeDeltas.add(new JMDelta(new JMChunk(selectedRow - 2 - leftEditor.getLineStartOffset(firstLine), selectedRowCount), new JMChunk(selectedColumn - 2 - leftEditor.getLineStartOffset(firstCol), selectedColumnCount)));
                                BufferDiffPanel.this.reDisplay();
                            }
                            catch (BadLocationException e1) {
                                System.out.println("Error building delta: " + e1.getMessage());
                                e1.printStackTrace();
                            }
                        }
                    });
                    return menuItem;
                }

                private boolean enableInsertAction(DefaultMutableTreeNode node) {
                    int selectedRow = BufferDiffPanel.this.levensteinGraphTable.getSelectedRow();
                    int selectedColumn = BufferDiffPanel.this.levensteinGraphTable.getSelectedColumn();
                    int selectedRowCount = BufferDiffPanel.this.levensteinGraphTable.getSelectedRowCount();
                    int selectedColumnCount = BufferDiffPanel.this.levensteinGraphTable.getSelectedColumnCount();
                    boolean deltaDefined = selectedColumnCount > 0 || selectedRowCount > 0;
                    return deltaDefined;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showPopup(e);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent me) {
                    TreePath tp = BufferDiffPanel.this.diffTree.getPathForLocation(me.getX(), me.getY());
                    if (tp != null) {
                        DefaultMutableTreeNode node;
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)node.getRoot();
                        for (node = (DefaultMutableTreeNode)tp.getLastPathComponent(); node != root; node = (DefaultMutableTreeNode)node.getParent()) {
                            Object userObject = node.getUserObject();
                            if (!(userObject instanceof JMDelta)) continue;
                            Object parentUserObject = ((DefaultMutableTreeNode)node.getParent()).getUserObject();
                            JMDelta lineDelta = (JMDelta)userObject;
                            JMDelta wordDelta = null;
                            if (parentUserObject instanceof JMDelta) {
                                wordDelta = lineDelta;
                                lineDelta = (JMDelta)parentUserObject;
                            }
                            this.doSelection(lineDelta, wordDelta);
                            break;
                        }
                    }
                }

                private void doSelection(JMDelta lineDelta, JMDelta wordDelta) {
                    int firstLine = lineDelta.getOriginal().getAnchor();
                    int lines = lineDelta.getOriginal().getSize();
                    int firstCol = lineDelta.getRevised().getAnchor();
                    int cols = lineDelta.getRevised().getSize();
                    int lineStartOffset = 0;
                    int lineEndOffset = 0;
                    int colStartOffset = 0;
                    int colEndOffset = 0;
                    try {
                        FilePanel leftFilePanel = BufferDiffPanel.this.filePanels[0];
                        FilePanel rightFilePanel = BufferDiffPanel.this.filePanels[2];
                        int leftLineCount = leftFilePanel.getEditor().getLineCount();
                        int rightLineCount = rightFilePanel.getEditor().getLineCount();
                        lineStartOffset = firstLine == leftLineCount ? leftFilePanel.getEditor().getLineEndOffset(firstLine - 1) : leftFilePanel.getEditor().getLineStartOffset(firstLine);
                        lineEndOffset = leftFilePanel.getEditor().getLineEndOffset(firstLine + lines - 1);
                        colStartOffset = firstCol == rightLineCount ? rightFilePanel.getEditor().getLineEndOffset(firstCol - 1) : rightFilePanel.getEditor().getLineStartOffset(firstCol);
                        colEndOffset = rightFilePanel.getEditor().getLineEndOffset(firstCol + cols - 1);
                        int lineOffset = 0;
                        if (lineDelta.isAdd()) {
                            --lineOffset;
                        }
                        int colOffset = 0;
                        if (lineDelta.isDelete()) {
                            --colOffset;
                        }
                        int startRow = lineStartOffset + 2 + lineOffset;
                        int endRow = lineEndOffset + 2 - 1;
                        int startCol = colStartOffset + 2 + colOffset;
                        int endCol = colEndOffset + 2 - 1;
                        if (wordDelta != null) {
                            int offsetLine = 0;
                            if (wordDelta.isChange() || wordDelta.isDelete()) {
                                --offsetLine;
                            }
                            int offsetCol = 0;
                            if (wordDelta.isChange() || wordDelta.isAdd()) {
                                --offsetCol;
                            }
                            JMChunk wordDeltaOriginal = wordDelta.getOriginal();
                            JMChunk wordDeltaRevised = wordDelta.getRevised();
                            endRow = (startRow += wordDeltaOriginal.getAnchor()) + wordDeltaOriginal.getSize() + offsetLine;
                            endCol = (startCol += wordDeltaRevised.getAnchor()) + wordDeltaRevised.getSize() + offsetCol;
                        }
                        BufferDiffPanel.this.levensteinGraphTable.clearSelection();
                        if (lineDelta.isAdd()) {
                            HashMap<Point, MatteBorder> rowLineSelection = BufferDiffPanel.this.createRowLineSelection(startRow - 2);
                            ((LevenshteinTableModel)BufferDiffPanel.this.levensteinGraphTable.getModel()).setBorderSelections(rowLineSelection);
                            startRow = -1;
                            endRow = -1;
                        }
                        if (lineDelta.isDelete()) {
                            HashMap<Point, MatteBorder> columnLineSelection = BufferDiffPanel.this.createColumnLineSelection(startCol - 2);
                            ((LevenshteinTableModel)BufferDiffPanel.this.levensteinGraphTable.getModel()).setBorderSelections(columnLineSelection);
                            startCol = -1;
                            endCol = -1;
                        }
                        BufferDiffPanel.this.levensteinGraphTable.changeSelection(startRow, startCol, false, false);
                        BufferDiffPanel.this.levensteinGraphTable.changeSelection(endRow, endCol, false, true);
                        BufferDiffPanel.this.levensteinGraphTable.repaint();
                    }
                    catch (BadLocationException e) {
                        System.err.printf("(%d, %d, %d, %d)%n", lineStartOffset, lineEndOffset, colStartOffset, colEndOffset);
                        System.err.printf("(%d, %d, %d, %d)%n", firstLine, lines, firstCol, cols);
                        e.printStackTrace();
                    }
                }
            });
            scrollTreePane.setViewportView(this.diffTree);
        }
        return scrollTreePane;
    }

    private JComponent buildLevenstheinTable() {
        if (!this.isShowLevenstein()) {
            return null;
        }
        final JSpinner spinner = new JSpinner(new SpinnerNumberModel(15, 5, Integer.MAX_VALUE, 1));
        this.levensteinGraphTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                boolean ok = false;
                if (this.autoResizeMode != 0 && this.getParent() instanceof JViewport) {
                    int tableWidth;
                    int parentWidth = this.getParent().getWidth();
                    ok = parentWidth > (tableWidth = this.getPreferredSize().width);
                }
                return ok;
            }

            @Override
            public void addColumn(TableColumn aColumn) {
                aColumn.setPreferredWidth((Integer)spinner.getValue());
                super.addColumn(aColumn);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }
        };
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TableColumnModel cm = BufferDiffPanel.this.levensteinGraphTable.getColumnModel();
                Integer preferredWidth = (Integer)spinner.getValue();
                for (int i = 0; i < cm.getColumnCount(); ++i) {
                    cm.getColumn(i).setPreferredWidth(preferredWidth);
                }
            }
        });
        this.levensteinGraphTable.setTableHeader(null);
        this.levensteinGraphTable.setFillsViewportHeight(true);
        JPanel panelGraph = new JPanel(new BorderLayout());
        panelGraph.add(new JScrollPane(this.levensteinGraphTable));
        JPanel bPanel = new JPanel(new FlowLayout(3));
        Box box = Box.createHorizontalBox();
        bPanel.add(new JLabel("Min Column Width"));
        bPanel.add(spinner);
        box.add(bPanel);
        box.add(Box.createHorizontalGlue());
        this.checkSolutionPath = new JCheckBox("Show solution path");
        this.checkSolutionPath.setSelected(true);
        this.checkSolutionPath.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ((LevenshteinTableModel)BufferDiffPanel.this.levensteinGraphTable.getModel()).setShowSelectionPath(BufferDiffPanel.this.checkSolutionPath.isSelected());
                BufferDiffPanel.this.levensteinGraphTable.repaint();
            }
        });
        box.add(this.checkSolutionPath);
        box.add(Box.createHorizontalGlue());
        final JLabel cellSelected = new JLabel("(,)");
        box.add(cellSelected);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowOrigin = BufferDiffPanel.this.levensteinGraphTable.getSelectedRow() - 2;
                int rowCount = BufferDiffPanel.this.levensteinGraphTable.getSelectedRowCount() + 1 - 2;
                int columnOrigin = BufferDiffPanel.this.levensteinGraphTable.getSelectedColumn() - 2;
                int columnCount = BufferDiffPanel.this.levensteinGraphTable.getSelectedColumnCount() + 1 - 2;
                cellSelected.setText("(" + rowOrigin + "," + (rowOrigin + rowCount) + "), (" + columnOrigin + "," + (columnOrigin + columnCount) + ")");
                BufferDiffPanel.this.levensteinGraphTable.repaint();
            }
        };
        this.levensteinGraphTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
        this.levensteinGraphTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.filePanels[0].getEditor().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                HashMap<Point, MatteBorder> borderSelection;
                int dot = e.getDot();
                int mark = e.getMark();
                BufferDiffPanel.this.levensteinGraphTable.clearSelection();
                if (dot == mark) {
                    borderSelection = BufferDiffPanel.this.createRowLineSelection(dot);
                    BufferDiffPanel.this.levensteinGraphTable.scrollRectToVisible(BufferDiffPanel.this.levensteinGraphTable.getCellRect(dot, 0, true));
                } else {
                    borderSelection = new HashMap();
                    if (mark > dot) {
                        int temp = dot;
                        dot = mark;
                        mark = temp;
                    }
                    BufferDiffPanel.this.levensteinGraphTable.changeSelection(dot + 2 - 1, BufferDiffPanel.this.levensteinGraphTable.getSelectedColumn(), false, false);
                    BufferDiffPanel.this.levensteinGraphTable.changeSelection(mark + 2, BufferDiffPanel.this.levensteinGraphTable.getSelectedColumn(), false, true);
                }
                ((LevenshteinTableModel)BufferDiffPanel.this.levensteinGraphTable.getModel()).setBorderSelections(borderSelection);
                BufferDiffPanel.this.levensteinGraphTable.repaint();
            }
        });
        this.filePanels[2].getEditor().addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                HashMap<Point, MatteBorder> borderSelection;
                int dot = e.getDot();
                int mark = e.getMark();
                BufferDiffPanel.this.levensteinGraphTable.clearSelection();
                if (dot == mark) {
                    borderSelection = BufferDiffPanel.this.createColumnLineSelection(dot);
                    BufferDiffPanel.this.levensteinGraphTable.scrollRectToVisible(BufferDiffPanel.this.levensteinGraphTable.getCellRect(0, dot, true));
                } else {
                    borderSelection = new HashMap();
                    if (mark > dot) {
                        int temp = dot;
                        dot = mark;
                        mark = temp;
                    }
                    BufferDiffPanel.this.levensteinGraphTable.changeSelection(BufferDiffPanel.this.levensteinGraphTable.getSelectedRow(), dot + 2 - 1, false, false);
                    BufferDiffPanel.this.levensteinGraphTable.changeSelection(BufferDiffPanel.this.levensteinGraphTable.getSelectedRow(), mark + 2, false, true);
                }
                ((LevenshteinTableModel)BufferDiffPanel.this.levensteinGraphTable.getModel()).setBorderSelections(borderSelection);
                BufferDiffPanel.this.levensteinGraphTable.repaint();
            }
        });
        panelGraph.add((Component)box, "South");
        return panelGraph;
    }

    private HashMap<Point, MatteBorder> createRowLineSelection(int row) {
        HashMap<Point, MatteBorder> borderSelection = new HashMap<Point, MatteBorder>();
        for (int i = 0; i < this.filePanels[0].getBufferDocument().getDocument().getLength(); ++i) {
            borderSelection.put(new Point(row, i), BorderFactory.createMatteBorder(2, 0, 0, 0, selectionColor));
        }
        return borderSelection;
    }

    private HashMap<Point, MatteBorder> createColumnLineSelection(int column) {
        HashMap<Point, MatteBorder> borderSelection = new HashMap<Point, MatteBorder>();
        for (int i = 0; i < this.filePanels[0].getBufferDocument().getDocument().getLength(); ++i) {
            borderSelection.put(new Point(i, column), BorderFactory.createMatteBorder(0, 2, 0, 0, selectionColor));
        }
        return borderSelection;
    }

    private void refreshLevensteinModel() {
        if (this.isShowLevenstein()) {
            try {
                PlainDocument orgDoc = this.filePanels[0].getBufferDocument().getDocument();
                PlainDocument revDoc = this.filePanels[2].getBufferDocument().getDocument();
                LevenshteinTableModel model = new LevenshteinTableModel();
                model.setOrigin(orgDoc.getText(0, orgDoc.getLength()));
                model.setDestiny(revDoc.getText(0, revDoc.getLength()));
                model.setCurrentRevision(this.currentRevision);
                model.setFilePanels(this.filePanels);
                model.setShowSelectionPath(this.checkSolutionPath.isSelected());
                model.buildModel();
                this.levensteinGraphTable.setModel(model);
                this.levensteinGraphTable.setDefaultRenderer(Object.class, model.getCellRenderer());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void toNextDelta(boolean next) {
        if (next) {
            this.doDown();
        } else {
            this.doUp();
        }
    }

    public JMRevision getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public boolean checkSave() {
        if (!this.isSaveEnabled()) {
            return true;
        }
        SavePanelDialog dialog = new SavePanelDialog(this.mainPanel);
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null) continue;
            dialog.add(filePanel.getBufferDocument());
        }
        dialog.show();
        if (dialog.isOK()) {
            dialog.doSave();
            return true;
        }
        return false;
    }

    @Override
    public void doSave() {
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null || !filePanel.isDocumentChanged()) continue;
            BufferDocumentIF document = filePanel.getBufferDocument();
            try {
                document.write();
            }
            catch (JMeldException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this.mainPanel, "Can't write file" + document.getName(), "Problem writing file", 0);
            }
        }
    }

    @Override
    public boolean isSaveEnabled() {
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null || !filePanel.isDocumentChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doStopSearch() {
        for (FilePanel filePanel : this.filePanels) {
            if (filePanel == null) continue;
            filePanel.doStopSearch();
        }
    }

    public SearchCommand getSearchCommand() {
        return this.mainPanel.getSearchCommand();
    }

    @Override
    public SearchHits doSearch() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return null;
        }
        SearchHits searchHits = fp.doSearch();
        this.scrollToSearch(fp, searchHits);
        return searchHits;
    }

    @Override
    public void doNextSearch() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return;
        }
        SearchHits searchHits = fp.getSearchHits();
        searchHits.next();
        fp.reDisplay();
        this.scrollToSearch(fp, searchHits);
    }

    @Override
    public void doPreviousSearch() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return;
        }
        SearchHits searchHits = fp.getSearchHits();
        searchHits.previous();
        fp.reDisplay();
        this.scrollToSearch(fp, searchHits);
    }

    @Override
    public void doRefresh() {
        this.diff();
    }

    @Override
    public void doMergeMode(boolean mergeMode) {
        for (FilePanel fp : this.filePanels) {
            if (fp == null) continue;
            fp.getEditor().setFocusable(!mergeMode);
        }
    }

    private void scrollToSearch(FilePanel fp, SearchHits searchHits) {
        if (searchHits == null) {
            return;
        }
        SearchHit currentHit = searchHits.getCurrent();
        if (currentHit != null) {
            int line = currentHit.getLine();
            this.scrollSynchronizer.scrollToLine(fp, line);
            this.setSelectedLine(line);
        }
    }

    private FilePanel getSelectedPanel() {
        if (this.filePanelSelectedIndex >= 0 && this.filePanelSelectedIndex < this.filePanels.length) {
            return this.filePanels[this.filePanelSelectedIndex];
        }
        return null;
    }

    void setSelectedPanel(FilePanel fp) {
        int index = -1;
        for (int i = 0; i < this.filePanels.length; ++i) {
            if (this.filePanels[i] != fp) continue;
            index = i;
        }
        if (index != this.filePanelSelectedIndex) {
            if (this.filePanelSelectedIndex != -1) {
                this.filePanels[this.filePanelSelectedIndex].setSelected(false);
            }
            this.filePanelSelectedIndex = index;
            if (this.filePanelSelectedIndex != -1) {
                this.filePanels[this.filePanelSelectedIndex].setSelected(true);
            }
        }
    }

    @Override
    public void checkActions() {
        this.mainPanel.checkActions();
    }

    @Override
    public void doLeft(boolean shift) {
        this.runChange(2, 0, shift);
    }

    @Override
    public void doRight(boolean shift) {
        this.runChange(0, 2, shift);
    }

    public void runChange(int fromPanelIndex, int toPanelIndex, boolean shift) {
        JMDelta delta = this.getSelectedDelta();
        if (delta == null) {
            return;
        }
        if (fromPanelIndex < 0 || fromPanelIndex >= this.filePanels.length) {
            return;
        }
        if (toPanelIndex < 0 || toPanelIndex >= this.filePanels.length) {
            return;
        }
        try {
            JMChunk toChunk;
            JMChunk fromChunk;
            BufferDocumentIF fromBufferDocument = this.filePanels[fromPanelIndex].getBufferDocument();
            BufferDocumentIF toBufferDocument = this.filePanels[toPanelIndex].getBufferDocument();
            if (fromPanelIndex < toPanelIndex) {
                fromChunk = delta.getOriginal();
                toChunk = delta.getRevised();
            } else {
                fromChunk = delta.getRevised();
                toChunk = delta.getOriginal();
            }
            JTextArea toEditor = this.filePanels[toPanelIndex].getEditor();
            if (fromBufferDocument == null || toBufferDocument == null) {
                return;
            }
            int fromLine = fromChunk.getAnchor();
            int size = fromChunk.getSize();
            int fromOffset = fromBufferDocument.getOffsetForLine(fromLine);
            if (fromOffset < 0) {
                return;
            }
            int toOffset = fromBufferDocument.getOffsetForLine(fromLine + size);
            if (toOffset < 0) {
                return;
            }
            PlainDocument from = fromBufferDocument.getDocument();
            String s = from.getText(fromOffset, toOffset - fromOffset);
            fromLine = toChunk.getAnchor();
            size = toChunk.getSize();
            fromOffset = toBufferDocument.getOffsetForLine(fromLine);
            if (fromOffset < 0) {
                return;
            }
            toOffset = toBufferDocument.getOffsetForLine(fromLine + size);
            if (toOffset < 0) {
                return;
            }
            this.getUndoHandler().start("replace");
            toEditor.setSelectionStart(fromOffset);
            toEditor.setSelectionEnd(toOffset);
            if (!shift) {
                toEditor.replaceSelection(s);
            } else {
                toEditor.getDocument().insertString(toOffset, s, null);
            }
            this.getUndoHandler().end("replace");
            this.setSelectedDelta(null);
            this.setSelectedLine(delta.getOriginal().getAnchor());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void runDelete(int fromPanelIndex, int toPanelIndex) {
        try {
            JMDelta delta = this.getSelectedDelta();
            if (delta == null) {
                return;
            }
            if (fromPanelIndex < 0 || fromPanelIndex >= this.filePanels.length) {
                return;
            }
            if (toPanelIndex < 0 || toPanelIndex >= this.filePanels.length) {
                return;
            }
            BufferDocumentIF bufferDocument = this.filePanels[fromPanelIndex].getBufferDocument();
            JMChunk chunk = fromPanelIndex < toPanelIndex ? delta.getOriginal() : delta.getRevised();
            JTextArea toEditor = this.filePanels[fromPanelIndex].getEditor();
            if (bufferDocument == null) {
                return;
            }
            PlainDocument document = bufferDocument.getDocument();
            int fromLine = chunk.getAnchor();
            int size = chunk.getSize();
            int fromOffset = bufferDocument.getOffsetForLine(fromLine);
            if (fromOffset < 0) {
                return;
            }
            int toOffset = bufferDocument.getOffsetForLine(fromLine + size);
            if (toOffset < 0) {
                return;
            }
            this.getUndoHandler().start("remove");
            toEditor.setSelectionStart(fromOffset);
            toEditor.setSelectionEnd(toOffset);
            toEditor.replaceSelection("");
            this.getUndoHandler().end("remove");
            this.setSelectedDelta(null);
            this.setSelectedLine(delta.getOriginal().getAnchor());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void doDown() {
        JMDelta sd;
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        int index = deltas.indexOf(sd = this.getSelectedDelta());
        if (index == -1 || sd.getOriginal().getAnchor() != this.selectedLine) {
            JMDelta d = null;
            Iterator<JMDelta> iterator = deltas.iterator();
            while (iterator.hasNext()) {
                JMDelta delta;
                d = delta = iterator.next();
                if (delta.getOriginal().getAnchor() <= this.selectedLine) continue;
                break;
            }
            this.setSelectedDelta(d);
        } else if (index + 1 < deltas.size()) {
            this.setSelectedDelta(deltas.get(index + 1));
        }
        this.showSelectedDelta();
    }

    @Override
    public void doUp() {
        JMDelta sd;
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        int index = deltas.indexOf(sd = this.getSelectedDelta());
        if (index == -1 || sd.getOriginal().getAnchor() != this.selectedLine) {
            JMDelta d = null;
            JMDelta previousDelta = null;
            Iterator<JMDelta> iterator = deltas.iterator();
            while (iterator.hasNext()) {
                JMDelta delta;
                d = delta = iterator.next();
                if (delta.getOriginal().getAnchor() > this.selectedLine) {
                    if (previousDelta == null) break;
                    d = previousDelta;
                    break;
                }
                previousDelta = delta;
            }
            this.setSelectedDelta(d);
        } else if (index - 1 >= 0) {
            this.setSelectedDelta(deltas.get(index - 1));
        }
        this.showSelectedDelta();
    }

    public void doGotoDelta(JMDelta delta) {
        this.setSelectedDelta(delta);
        this.showSelectedDelta();
    }

    public void doGotoLine(int line) {
        this.setSelectedLine(line);
        FilePanel fp = this.getFilePanel(0);
        BufferDocumentIF bd = fp.getBufferDocument();
        if (bd == null) {
            return;
        }
        int offset = bd.getOffsetForLine(line);
        JViewport viewport = fp.getScrollPane().getViewport();
        JTextArea editor = fp.getEditor();
        Rectangle rect = viewport.getViewRect();
        int startOffset = editor.viewToModel(rect.getLocation());
        int endOffset = editor.viewToModel(new Point(rect.x, rect.y + rect.height));
        if (offset >= startOffset && offset <= endOffset) {
            return;
        }
        try {
            Point p = editor.modelToView(offset).getLocation();
            p.x = 0;
            viewport.setViewPosition(p);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void doZoom(boolean direction) {
        for (FilePanel p : this.filePanels) {
            if (p == null) continue;
            JTextArea c = p.getEditor();
            Zoom zoom = (Zoom)c.getClientProperty("JMeld.zoom");
            if (zoom == null) {
                zoom = new Zoom();
                zoom.font = c.getFont();
                c.putClientProperty("JMeld.zoom", zoom);
            }
            float size = (float)c.getFont().getSize() + (direction ? 1.0f : -1.0f);
            size = size > 100.0f ? 100.0f : size;
            size = size < 5.0f ? 5.0f : size;
            ((JComponent)c).setFont(zoom.font.deriveFont(size));
        }
    }

    @Override
    public void doGoToSelected() {
        this.showSelectedDelta();
    }

    @Override
    public void doGoToFirst() {
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        if (deltas.size() > 0) {
            this.setSelectedDelta(deltas.get(0));
            this.showSelectedDelta();
        }
    }

    @Override
    public void doGoToLast() {
        if (this.currentRevision == null) {
            return;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        if (deltas.size() > 0) {
            this.setSelectedDelta(deltas.get(deltas.size() - 1));
            this.showSelectedDelta();
        }
    }

    @Override
    public void doGoToLine(int line) {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return;
        }
        this.scrollSynchronizer.scrollToLine(fp, line);
        this.setSelectedLine(line);
    }

    @Override
    public void configurationChanged() {
        this.readConfig();
        this.init();
        this.refreshDiffNode();
        this.reDisplay();
        this.diff();
    }

    private void readConfig() {
        this.setShowTree(JMeldSettings.getInstance().getEditor().isShowTreeChunks());
        this.setShowLevenstein(JMeldSettings.getInstance().getEditor().isShowLevenstheinEditor());
    }

    public void setSelectedDelta(JMDelta delta) {
        this.selectedDelta = delta;
        this.setSelectedLine(delta == null ? 0 : delta.getOriginal().getAnchor());
    }

    private void setSelectedLine(int line) {
        this.selectedLine = line;
    }

    private void showSelectedDelta() {
        JMDelta delta = this.getSelectedDelta();
        if (delta == null) {
            return;
        }
        this.scrollSynchronizer.showDelta(delta);
    }

    public JMDelta getSelectedDelta() {
        if (this.currentRevision == null) {
            return null;
        }
        List<JMDelta> deltas = this.currentRevision.getDeltas();
        if (deltas.size() == 0) {
            return null;
        }
        return this.selectedDelta;
    }

    public FilePanel getFilePanel(int index) {
        if (index < 0 || index > this.filePanels.length) {
            return null;
        }
        return this.filePanels[index];
    }

    @Override
    public String getSelectedText() {
        FilePanel fp = this.getSelectedPanel();
        if (fp == null) {
            return null;
        }
        return fp.getSelectedText();
    }

    static {
        selectionColor = new Color(selectionColor.getRed() * newColor.getRed() / mixColor.getRed(), selectionColor.getGreen() * newColor.getGreen() / mixColor.getGreen(), selectionColor.getBlue() * newColor.getBlue() / mixColor.getBlue());
    }

    class Zoom {
        Font font;

        Zoom() {
        }
    }
}

