/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class DefaultContextMenu
extends JPopupMenu {
    private Clipboard clipboard;
    private UndoManager undoManager = new UndoManager();
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem cut;
    private JMenuItem copy;
    private JMenuItem paste;
    private JMenuItem delete;
    private JMenuItem selectAll;
    private JTextComponent jTextComponent;

    public DefaultContextMenu() {
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.undo = new JMenuItem("Undo");
        this.undo.setEnabled(false);
        this.undo.setAccelerator(KeyStroke.getKeyStroke("control Z"));
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultContextMenu.this.undoManager.undo();
            }
        });
        this.add(this.undo);
        this.redo = new JMenuItem("Redo");
        this.redo.setEnabled(false);
        this.redo.setAccelerator(KeyStroke.getKeyStroke("control Y"));
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultContextMenu.this.undoManager.redo();
            }
        });
        this.add(this.redo);
        this.add(new JSeparator());
        this.cut = new JMenuItem("Cut");
        this.cut.setEnabled(false);
        this.cut.setAccelerator(KeyStroke.getKeyStroke("control X"));
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultContextMenu.this.jTextComponent.cut();
            }
        });
        this.add(this.cut);
        this.copy = new JMenuItem("Copy");
        this.copy.setEnabled(false);
        this.copy.setAccelerator(KeyStroke.getKeyStroke("control C"));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultContextMenu.this.jTextComponent.copy();
            }
        });
        this.add(this.copy);
        this.paste = new JMenuItem("Paste");
        this.paste.setEnabled(false);
        this.paste.setAccelerator(KeyStroke.getKeyStroke("control V"));
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultContextMenu.this.jTextComponent.paste();
            }
        });
        this.add(this.paste);
        this.delete = new JMenuItem("Delete");
        this.delete.setEnabled(false);
        this.delete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultContextMenu.this.jTextComponent.replaceSelection("");
            }
        });
        this.add(this.delete);
        this.add(new JSeparator());
        this.selectAll = new JMenuItem("Select All");
        this.selectAll.setEnabled(false);
        this.selectAll.setAccelerator(KeyStroke.getKeyStroke("control A"));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DefaultContextMenu.this.jTextComponent.selectAll();
            }
        });
        this.add(this.selectAll);
    }

    public void add(JTextComponent jTextComponent) {
        jTextComponent.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent pressedEvent) {
                if (pressedEvent.getKeyCode() == 90 && (pressedEvent.getModifiers() & 2) != 0 && DefaultContextMenu.this.undoManager.canUndo()) {
                    DefaultContextMenu.this.undoManager.undo();
                }
                if (pressedEvent.getKeyCode() == 89 && (pressedEvent.getModifiers() & 2) != 0 && DefaultContextMenu.this.undoManager.canRedo()) {
                    DefaultContextMenu.this.undoManager.redo();
                }
            }
        });
        jTextComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent releasedEvent) {
                if (releasedEvent.getButton() == 3) {
                    DefaultContextMenu.this.processClick(releasedEvent);
                }
            }
        });
        jTextComponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent event) {
                DefaultContextMenu.this.undoManager.addEdit(event.getEdit());
            }
        });
    }

    private void processClick(MouseEvent event) {
        this.jTextComponent = (JTextComponent)event.getSource();
        boolean enableUndo = this.undoManager.canUndo();
        boolean enableRedo = this.undoManager.canRedo();
        boolean enableCut = false;
        boolean enableCopy = false;
        boolean enablePaste = false;
        boolean enableDelete = false;
        boolean enableSelectAll = false;
        String selectedText = this.jTextComponent.getSelectedText();
        String text = this.jTextComponent.getText();
        if (text != null && text.length() > 0) {
            enableSelectAll = true;
        }
        if (selectedText != null && selectedText.length() > 0) {
            enableCut = true;
            enableCopy = true;
            enableDelete = true;
        }
        try {
            if (this.clipboard.getData(DataFlavor.stringFlavor) != null) {
                enablePaste = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.undo.setEnabled(enableUndo);
        this.redo.setEnabled(enableRedo);
        this.cut.setEnabled(enableCut);
        this.copy.setEnabled(enableCopy);
        this.paste.setEnabled(enablePaste);
        this.delete.setEnabled(enableDelete);
        this.selectAll.setEnabled(enableSelectAll);
        this.show(this.jTextComponent, event.getX(), event.getY());
    }
}

