/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jidesoft.swing.JideTabbedPane;
import java.io.File;
import javax.swing.JOptionPane;
import org.jdesktop.swingworker.SwingWorker;
import org.jmeld.settings.util.Filter;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.FolderDiffPanel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.StringUtil;
import org.jmeld.util.file.DirectoryDiff;
import org.jmeld.util.file.FolderDiff;

public class DirectoryComparison
extends SwingWorker<String, Object> {
    private File leftFile;
    private File rightFile;
    private Filter filter;
    private DirectoryDiff diff;
    private AbstractContentPanel contentPanel;
    private String contentId;
    private JMeldPanel mainPanel;

    public DirectoryComparison(JMeldPanel mainPanel, File leftFile, File rightFile, Filter filter) {
        this.mainPanel = mainPanel;
        this.leftFile = leftFile;
        this.rightFile = rightFile;
        this.filter = filter;
    }

    @Override
    public String doInBackground() {
        if (StringUtil.isEmpty(this.leftFile.getName())) {
            return "left directoryName is empty";
        }
        if (!this.leftFile.exists()) {
            return "left directoryName(" + this.leftFile.getAbsolutePath() + ") doesn't exist";
        }
        if (!this.leftFile.isDirectory()) {
            return "left directoryName(" + this.leftFile.getName() + ") is not a directory";
        }
        if (StringUtil.isEmpty(this.rightFile.getName())) {
            return "right directoryName is empty";
        }
        if (!this.rightFile.exists()) {
            return "right directoryName(" + this.rightFile.getAbsolutePath() + ") doesn't exist";
        }
        if (!this.rightFile.isDirectory()) {
            return "right directoryName(" + this.rightFile.getName() + ") is not a directory";
        }
        this.contentId = "FolderDiffPanel:" + this.leftFile.getName() + "-" + this.rightFile.getName();
        this.contentPanel = JMeldPanel.getAlreadyOpen(this.mainPanel.getTabbedPane(), this.contentId);
        if (this.contentPanel == null) {
            this.diff = new DirectoryDiff(this.leftFile, this.rightFile, this.filter, FolderDiff.Mode.TWO_WAY);
            this.diff.diff();
        }
        return null;
    }

    @Override
    protected void done() {
        try {
            String result = (String)this.get();
            if (result != null) {
                JOptionPane.showMessageDialog(this.mainPanel, result, "Error opening file", 0);
            } else {
                JideTabbedPane tabbedPane = this.mainPanel.getTabbedPane();
                if (tabbedPane != null) {
                    if (this.contentPanel != null) {
                        tabbedPane.setSelectedComponent(this.contentPanel);
                    } else {
                        FolderDiffPanel panel = new FolderDiffPanel(this.mainPanel, this.diff);
                        panel.setId(this.contentId);
                        tabbedPane.addTab(panel.getTitle(), ImageUtil.getSmallImageIcon("stock_folder"), panel);
                        tabbedPane.setSelectedComponent(panel);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

