/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingworker.SwingWorker;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.StringUtil;
import org.jmeld.util.node.JMDiffNode;
import org.jmeld.util.node.JMDiffNodeFactory;

public class FileComparison
extends SwingWorker<String, Object> {
    private JMeldPanel mainPanel;
    private JMDiffNode diffNode;
    private File leftFile;
    private File rightFile;
    private BufferDiffPanel panel;
    private AbstractContentPanel contentPanel;
    private String contentId;
    private boolean openInBackground;
    private boolean showLevenstein;
    private boolean showTree;

    public FileComparison(JMeldPanel mainPanel, JMDiffNode diffNode) {
        this.mainPanel = mainPanel;
        this.diffNode = diffNode;
    }

    public FileComparison(JMeldPanel mainPanel, File leftFile, File rightFile) {
        this.mainPanel = mainPanel;
        this.leftFile = leftFile;
        this.rightFile = rightFile;
    }

    public boolean isShowTree() {
        return this.showTree;
    }

    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    public boolean isShowLevenstein() {
        return this.showLevenstein;
    }

    public void setShowLevenstein(boolean showLevenstein) {
        this.showLevenstein = showLevenstein;
    }

    public boolean isOpenInBackground() {
        return this.openInBackground;
    }

    public void setOpenInBackground(boolean openInBackground) {
        this.openInBackground = openInBackground;
    }

    @Override
    public String doInBackground() {
        try {
            if (this.diffNode == null) {
                if (StringUtil.isEmpty(this.leftFile.getName()) || !this.leftFile.exists()) {
                    this.leftFile = new File(this.leftFile.getName());
                }
                if (StringUtil.isEmpty(this.rightFile.getName()) || !this.rightFile.exists()) {
                    this.rightFile = new File(this.rightFile.getName());
                }
                this.diffNode = JMDiffNodeFactory.create(this.leftFile.getName(), this.leftFile, this.rightFile.getName(), this.rightFile);
            }
            this.contentId = "BufferDiffPanel:" + this.diffNode.getId();
            this.contentPanel = JMeldPanel.getAlreadyOpen(this.mainPanel.getTabbedPane(), this.contentId);
            if (this.contentPanel == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileComparison.this.diffNode.diff();
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ex.getMessage();
        }
        return null;
    }

    @Override
    protected void done() {
        try {
            String result = (String)this.get();
            if (result != null) {
                JOptionPane.showMessageDialog(this.mainPanel, result, "Error opening file", 0);
            } else if (this.contentPanel != null) {
                this.mainPanel.getTabbedPane().setSelectedComponent(this.contentPanel);
            } else {
                this.panel = new BufferDiffPanel(this.mainPanel);
                this.panel.setId(this.contentId);
                this.panel.setDiffNode(this.diffNode);
                this.mainPanel.getTabbedPane().addTab(this.panel.getTitle(), ImageUtil.getSmallImageIcon("stock_new"), this.panel);
                if (!this.openInBackground) {
                    this.mainPanel.getTabbedPane().setSelectedComponent(this.panel);
                }
                SwingUtilities.invokeLater(this.doGoToFirst());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Runnable doGoToFirst() {
        return new Runnable(){

            @Override
            public void run() {
                FileComparison.this.panel.doGoToFirst();
                FileComparison.this.panel.repaint();
            }
        };
    }
}

