/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import javax.swing.Icon;
import org.jmeld.ui.UINode;
import org.jmeld.ui.swing.table.JMTreeTableModel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.JMDiffNode;

public class FolderDiffTreeTableModel
extends JMTreeTableModel {
    private JMTreeTableModel.Column fileNameLeftColumn = this.addColumn("leftFileName", "Left", "L File", null, 40, false);
    private JMTreeTableModel.Column leftSizeColumn = this.addColumn("leftSize", "Left", "Size", Integer.class, 8, false);
    private JMTreeTableModel.Column leftStateColumn = this.addColumn("leftState", "Left", "L", Icon.class, 3, false);
    private JMTreeTableModel.Column sepColumn = this.addColumn("sepColumn", null, "Sep", Icon.class, -1, false);
    private JMTreeTableModel.Column fileNameRightColumn = this.addColumn("rightFileName", "Right", "R File", null, 40, false);
    private JMTreeTableModel.Column rightSizeColumn;
    private JMTreeTableModel.Column rightStateColumn = this.addColumn("rightState", "Right", "R", Icon.class, 3, false);

    public FolderDiffTreeTableModel() {
        this.rightSizeColumn = this.addColumn("rightSize", "Right", "Size", Integer.class, 8, false);
    }

    @Override
    public Object getValueAt(Object objectNode, JMTreeTableModel.Column column) {
        UINode uiNode = (UINode)objectNode;
        JMDiffNode diffNode = uiNode.getDiffNode();
        if (column == this.fileNameLeftColumn) {
            return uiNode.toString();
        }
        if (column == this.fileNameRightColumn) {
            return uiNode.toString();
        }
        if (column == this.leftStateColumn) {
            return ImageUtil.getSmallImageIcon(this.getLeftStateIconName(diffNode));
        }
        if (column == this.leftSizeColumn) {
            if (diffNode == null) {
                return "";
            }
            BufferNode bufferNode = diffNode.getBufferNodeLeft();
            if (bufferNode == null) {
                return "";
            }
            return bufferNode.getSize();
        }
        if (column == this.rightStateColumn) {
            return ImageUtil.getSmallImageIcon(this.getRightStateIconName(diffNode));
        }
        if (column == this.rightSizeColumn) {
            if (diffNode == null) {
                return "";
            }
            BufferNode bufferNode = diffNode.getBufferNodeRight();
            if (bufferNode == null) {
                return "";
            }
            return bufferNode.getSize();
        }
        return null;
    }

    public void setValueAt(Object value, Object objectNode, JMTreeTableModel.Column column) {
    }

    private String getLeftStateIconName(JMDiffNode diffNode) {
        if (diffNode != null) {
            if (diffNode.isCompareEqual(JMDiffNode.Compare.NotEqual)) {
                return "stock_changed2";
            }
            if (diffNode.isCompareEqual(JMDiffNode.Compare.LeftMissing) || diffNode.isCompareEqual(JMDiffNode.Compare.BothMissing)) {
                return "stock_deleted3";
            }
        }
        return "stock_equal";
    }

    private String getRightStateIconName(JMDiffNode diffNode) {
        if (diffNode != null) {
            if (diffNode.isCompareEqual(JMDiffNode.Compare.NotEqual)) {
                return "stock_changed2";
            }
            if (diffNode.isCompareEqual(JMDiffNode.Compare.RightMissing) || diffNode.isCompareEqual(JMDiffNode.Compare.BothMissing)) {
                return "stock_deleted3";
            }
        }
        return "stock_equal";
    }
}

