/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.NavigatorView;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingworker.SwingWorker;
import org.jmeld.Version;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.AbstractBarDialog;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.DirectoryComparison;
import org.jmeld.ui.FileComparison;
import org.jmeld.ui.JMeldContentPanelIF;
import org.jmeld.ui.Option;
import org.jmeld.ui.PanelDialog;
import org.jmeld.ui.StatusBar;
import org.jmeld.ui.VersionControlComparison;
import org.jmeld.ui.action.ActionHandler;
import org.jmeld.ui.action.Actions;
import org.jmeld.ui.action.MeldAction;
import org.jmeld.ui.bar.LineNumberBarDialog;
import org.jmeld.ui.search.SearchBarDialog;
import org.jmeld.ui.search.SearchCommand;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.settings.SettingsPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.SwingUtil;
import org.jmeld.ui.util.TabIcon;
import org.jmeld.ui.util.ToolBarBuilder;
import org.jmeld.ui.util.WidgetFactory;
import org.jmeld.util.ObjectUtil;
import org.jmeld.util.StringUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.vc.VersionControlUtil;

public class JMeldPanel
extends JPanel
implements ConfigurationListenerIF,
PropertyChangeListener {
    public final Actions actions;
    public final Option SHOW_TOOLBAR_OPTION;
    public final Option SHOW_STATUSBAR_OPTION;
    public final Option SHOW_TABBEDPANE_OPTION;
    public final Option SHOW_FILE_LABEL_OPTION;
    public final Option SHOW_FILE_SAVE_BAR_OPTION;
    public final Option SHOW_FILE_STATUSBAR_OPTION;
    public final Option STANDALONE_INSTALLKEY_OPTION;
    private ActionHandler actionHandler;
    private JideTabbedPane tabbedPane;
    private JPanel barContainer;
    private AbstractBarDialog currentBarDialog;
    private SearchBarDialog searchBarDialog;
    private JComponent toolBar;
    private boolean mergeMode;
    private boolean started;

    public JMeldPanel() {
        this.setFocusable(true);
        this.tabbedPane = new JideTabbedPane();
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JMeldPanel.this.start();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.SHOW_TOOLBAR_OPTION = new Option(this, true);
        this.SHOW_STATUSBAR_OPTION = new Option(this, true);
        this.SHOW_TABBEDPANE_OPTION = new Option(this, true);
        this.SHOW_FILE_LABEL_OPTION = new Option(this, true);
        this.SHOW_FILE_STATUSBAR_OPTION = new Option(this, true);
        this.SHOW_FILE_SAVE_BAR_OPTION = new Option(this, true);
        this.STANDALONE_INSTALLKEY_OPTION = new Option(this, false);
        this.actions = new Actions();
    }

    public JideTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.getTabbedPane().setFocusable(false);
        this.getTabbedPane().setShowCloseButtonOnTab(true);
        this.getTabbedPane().setShowCloseButtonOnSelectedTab(true);
        if (!this.SHOW_TABBEDPANE_OPTION.isEnabled()) {
            this.getTabbedPane().setShowTabArea(false);
        }
        this.getTabbedPane().setTabShape(4);
        this.initActions();
        if (this.SHOW_TABBEDPANE_OPTION.isEnabled()) {
            this.getTabbedPane().setCloseAction(this.getAction(this.actions.EXIT));
        }
        this.setLayout(new BorderLayout());
        this.addToolBar();
        this.add((Component)this.getTabbedPane(), "Center");
        this.add((Component)this.getBar(), "Last");
        this.getTabbedPane().getModel().addChangeListener(this.getChangeListener());
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    public void openComparison(List<String> fileNameList) {
        if (fileNameList.size() <= 0) {
            return;
        }
        if (fileNameList.size() > 1) {
            if (new File(fileNameList.get(0)).isDirectory()) {
                String fileName1 = fileNameList.get(0);
                for (int i = 1; i < fileNameList.size(); ++i) {
                    String fileName2 = fileNameList.get(i);
                    this.openComparison(fileName1, fileName2);
                }
            } else {
                for (int i = 0; i < fileNameList.size(); i += 2) {
                    String fileName1 = fileNameList.get(i);
                    if (i + 1 >= fileNameList.size()) continue;
                    String fileName2 = fileNameList.get(i + 1);
                    this.openComparison(fileName1, fileName2);
                }
            }
        } else {
            this.openComparison(fileNameList.get(0), null);
        }
    }

    public void openComparison(String leftName, String rightName) {
        File file;
        if (!StringUtil.isEmpty(leftName) && !StringUtil.isEmpty(rightName)) {
            File leftFile = new File(leftName);
            File rightFile = new File(rightName);
            if (leftFile.isDirectory()) {
                if (rightFile.isDirectory()) {
                    new DirectoryComparison(this, leftFile, rightFile, JMeldSettings.getInstance().getFilter().getFilter("default")).execute();
                } else {
                    FileComparison fileComparison = new FileComparison(this, new File(leftFile, rightName), rightFile);
                    fileComparison.setOpenInBackground(false);
                    fileComparison.execute();
                }
            } else {
                FileComparison fileComparison = new FileComparison(this, leftFile, rightFile);
                fileComparison.setOpenInBackground(false);
                fileComparison.execute();
            }
        } else if (!StringUtil.isEmpty(leftName) && (file = new File(leftName)).exists() && VersionControlUtil.isVersionControlled(file)) {
            VersionControlComparison versionControlComparison = new VersionControlComparison(this, file);
            versionControlComparison.execute();
        }
    }

    public MeldAction getAction(Actions.Action action) {
        return this.getActionHandler().get(action);
    }

    public void addToolBar() {
        if (this.SHOW_TOOLBAR_OPTION.isEnabled()) {
            if (this.toolBar != null) {
                this.remove(this.toolBar);
            }
            this.toolBar = this.getToolBar();
            this.add((Component)this.toolBar, "First");
            this.revalidate();
        }
    }

    private JComponent getToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        tb.setRollover(true);
        ToolBarBuilder builder = new ToolBarBuilder(tb);
        JButton button = WidgetFactory.getToolBarButton(this.getAction(this.actions.NEW));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.getAction(this.actions.SAVE));
        builder.addButton(button);
        builder.addSeparator();
        button = WidgetFactory.getToolBarButton(this.getAction(this.actions.UNDO));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.getAction(this.actions.REDO));
        builder.addButton(button);
        builder.addSpring();
        button = WidgetFactory.getToolBarButton(this.getAction(this.actions.SETTINGS));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.getAction(this.actions.HELP));
        builder.addButton(button);
        button = WidgetFactory.getToolBarButton(this.getAction(this.actions.ABOUT));
        builder.addButton(button);
        return tb;
    }

    private JComponent getBar() {
        CellConstraints cc = new CellConstraints();
        this.barContainer = new JPanel(new FormLayout("0:grow", "pref, pref, pref"));
        this.barContainer.add((Component)new JSeparator(), cc.xy(1, 2));
        if (this.SHOW_STATUSBAR_OPTION.isEnabled()) {
            this.barContainer.add((Component)StatusBar.getInstance(), cc.xy(1, 3));
        }
        return this.barContainer;
    }

    private SearchBarDialog getSearchBarDialog() {
        if (this.searchBarDialog == null) {
            this.searchBarDialog = new SearchBarDialog(this);
        }
        return this.searchBarDialog;
    }

    public void initActions() {
        this.actionHandler = new ActionHandler();
        MeldAction action = this.actionHandler.createAction(this, this.actions.NEW);
        action.setIcon("stock_new");
        action.setToolTip("Merge 2 new files");
        action = this.actionHandler.createAction(this, this.actions.SAVE);
        action.setIcon("stock_save");
        action.setToolTip("Save the changed files");
        if (!this.STANDALONE_INSTALLKEY_OPTION.isEnabled()) {
            this.installKey("ctrl S", action);
        }
        action = this.actionHandler.createAction(this, this.actions.UNDO);
        action.setIcon("stock_undo");
        action.setToolTip("Undo the latest change");
        this.installKey("control Z", action);
        this.installKey("control Y", action);
        action = this.actionHandler.createAction(this, this.actions.REDO);
        action.setIcon("stock_redo");
        action.setToolTip("Redo the latest change");
        this.installKey("control R", action);
        action = this.actionHandler.createAction(this, this.actions.LEFT);
        this.installKey("LEFT", action);
        this.installKey("alt LEFT", action);
        this.installKey("alt KP_LEFT", action);
        action = this.actionHandler.createAction(this, this.actions.RIGHT);
        this.installKey("RIGHT", action);
        this.installKey("alt RIGHT", action);
        this.installKey("alt KP_RIGHT", action);
        action = this.actionHandler.createAction(this, this.actions.UP);
        this.installKey("UP", action);
        this.installKey("alt UP", action);
        this.installKey("alt KP_UP", action);
        this.installKey("F7", action);
        action = this.actionHandler.createAction(this, this.actions.DOWN);
        this.installKey("DOWN", action);
        this.installKey("alt DOWN", action);
        this.installKey("alt KP_DOWN", action);
        this.installKey("F8", action);
        action = this.actionHandler.createAction(this, this.actions.ZOOM_PLUS);
        this.installKey("alt EQUALS", action);
        this.installKey("shift alt EQUALS", action);
        this.installKey("alt ADD", action);
        action = this.actionHandler.createAction(this, this.actions.ZOOM_MIN);
        this.installKey("alt MINUS", action);
        this.installKey("shift alt MINUS", action);
        this.installKey("alt SUBTRACT", action);
        action = this.actionHandler.createAction(this, this.actions.GOTO_SELECTED);
        this.installKey("alt ENTER", action);
        action = this.actionHandler.createAction(this, this.actions.GOTO_FIRST);
        this.installKey("alt HOME", action);
        action = this.actionHandler.createAction(this, this.actions.GOTO_LAST);
        this.installKey("alt END", action);
        action = this.actionHandler.createAction(this, this.actions.GOTO_LINE);
        this.installKey("ctrl L", action);
        action = this.actionHandler.createAction(this, this.actions.START_SEARCH);
        this.installKey("ctrl F", action);
        action = this.actionHandler.createAction(this, this.actions.NEXT_SEARCH);
        this.installKey("F3", action);
        this.installKey("ctrl G", action);
        action = this.actionHandler.createAction(this, this.actions.PREVIOUS_SEARCH);
        this.installKey("shift F3", action);
        action = this.actionHandler.createAction(this, this.actions.REFRESH);
        this.installKey("F5", action);
        action = this.actionHandler.createAction(this, this.actions.MERGEMODE);
        this.installKey("F9", action);
        if (!this.STANDALONE_INSTALLKEY_OPTION.isEnabled()) {
            action = this.actionHandler.createAction(this, this.actions.HELP);
            action.setIcon("stock_help-agent");
            this.installKey("F1", action);
            action = this.actionHandler.createAction(this, this.actions.ABOUT);
            action.setIcon("stock_about");
            action = this.actionHandler.createAction(this, this.actions.SETTINGS);
            action.setIcon("stock_preferences");
            action.setToolTip("Settings");
            action = this.actionHandler.createAction(this, this.actions.EXIT);
            this.installKey("ESCAPE", action);
        }
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public void checkActions() {
        if (this.actionHandler != null) {
            this.actionHandler.checkActions();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && SwingWorker.StateValue.DONE.equals(evt.getNewValue())) {
            try {
                String result = (String)((SwingWorker)evt.getSource()).get();
                if (result != null) {
                    this.launchDialog();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void doNew(ActionEvent ae) {
        this.launchDialog();
    }

    private void launchDialog() {
        PanelDialog dialog = new PanelDialog(this);
        dialog.show();
        SwingWorker worker = null;
        if (dialog.getFunction() == PanelDialog.Function.FILE_COMPARISON) {
            worker = new FileComparison(this, new File(dialog.getLeftFileName()), new File(dialog.getRightFileName()));
        } else if (dialog.getFunction() == PanelDialog.Function.DIRECTORY_COMPARISON) {
            worker = new DirectoryComparison(this, new File(dialog.getLeftDirectoryName()), new File(dialog.getRightDirectoryName()), dialog.getFilter());
        } else if (dialog.getFunction() == PanelDialog.Function.VERSION_CONTROL) {
            worker = new VersionControlComparison(this, new File(dialog.getVersionControlDirectoryName()));
        }
        worker.addPropertyChangeListener(this);
        worker.execute();
    }

    public void doSave(ActionEvent ae) {
        this.getCurrentContentPanel().doSave();
    }

    public boolean isSaveEnabled() {
        AbstractContentPanel panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isSaveEnabled();
    }

    public void doUndo(ActionEvent ae) {
        this.getCurrentContentPanel().doUndo();
    }

    public boolean isUndoEnabled() {
        AbstractContentPanel panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isUndoEnabled();
    }

    public void doRedo(ActionEvent ae) {
        this.getCurrentContentPanel().doRedo();
    }

    public boolean isRedoEnabled() {
        AbstractContentPanel panel = this.getCurrentContentPanel();
        if (panel == null) {
            return false;
        }
        return panel.isRedoEnabled();
    }

    public void doLeft(ActionEvent ae) {
        boolean shift = false;
        int onmask = 1088;
        int offmask = 128;
        if ((ae.getModifiers() & (onmask | offmask)) == onmask) {
            shift = true;
        }
        this.getCurrentContentPanel().doLeft(shift);
        this.repaint();
    }

    public void doRight(ActionEvent ae) {
        boolean shift = false;
        int onmask = 1088;
        int offmask = 128;
        if ((ae.getModifiers() & (onmask | offmask)) == onmask) {
            shift = true;
        }
        this.getCurrentContentPanel().doRight(shift);
        this.repaint();
    }

    public void doUp(ActionEvent ae) {
        this.getCurrentContentPanel().doUp();
        this.repaint();
    }

    public void doDown(ActionEvent ae) {
        this.getCurrentContentPanel().doDown();
        this.repaint();
    }

    public void doZoomPlus(ActionEvent ae) {
        this.getCurrentContentPanel().doZoom(true);
        this.repaint();
    }

    public void doZoomMin(ActionEvent ae) {
        this.getCurrentContentPanel().doZoom(false);
        this.repaint();
    }

    public void doGoToSelected(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToSelected();
        this.repaint();
    }

    public void doGoToFirst(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToFirst();
        this.repaint();
    }

    public void doGoToLast(ActionEvent ae) {
        this.getCurrentContentPanel().doGoToLast();
        this.repaint();
    }

    public void doGoToLine(ActionEvent ae) {
        this.activateBarDialog(new LineNumberBarDialog(this));
    }

    public void doGoToLine(int line) {
        this.getCurrentContentPanel().doGoToLine(line);
        this.repaint();
        this.deactivateBarDialog();
    }

    public void doStartSearch(ActionEvent ae) {
        SearchBarDialog sbd = this.getSearchBarDialog();
        sbd.setSearchText(this.getSelectedSearchText());
        this.activateBarDialog(sbd);
    }

    public void doStopSearch(ActionEvent ae) {
        this.deactivateBarDialog();
        for (JMeldContentPanelIF jMeldContentPanelIF : JMeldPanel.getContentPanelList(this.getTabbedPane())) {
            jMeldContentPanelIF.doStopSearch();
        }
    }

    public SearchHits doSearch(ActionEvent ae) {
        return this.getCurrentContentPanel().doSearch();
    }

    SearchCommand getSearchCommand() {
        if (this.currentBarDialog != this.getSearchBarDialog()) {
            return null;
        }
        return this.getSearchBarDialog().getCommand();
    }

    public void doNextSearch(ActionEvent ae) {
        if (this.currentBarDialog != this.getSearchBarDialog()) {
            return;
        }
        this.getCurrentContentPanel().doNextSearch();
    }

    public void doPreviousSearch(ActionEvent ae) {
        if (this.currentBarDialog != this.getSearchBarDialog()) {
            return;
        }
        this.getCurrentContentPanel().doPreviousSearch();
    }

    private String getSelectedSearchText() {
        return this.getCurrentContentPanel().getSelectedText();
    }

    public void doRefresh(ActionEvent ae) {
        this.getCurrentContentPanel().doRefresh();
    }

    public void doMergeMode(ActionEvent ae) {
        this.mergeMode = !this.mergeMode;
        MeldAction action = this.getAction(this.actions.LEFT);
        this.installKey(this.mergeMode, "LEFT", action);
        action = this.getAction(this.actions.RIGHT);
        this.installKey(this.mergeMode, "RIGHT", action);
        action = this.getAction(this.actions.UP);
        this.installKey(this.mergeMode, "UP", action);
        action = this.getAction(this.actions.DOWN);
        this.installKey(this.mergeMode, "DOWN", action);
        this.getCurrentContentPanel().doMergeMode(this.mergeMode);
        this.requestFocus();
        if (this.mergeMode) {
            StatusBar.getInstance().setNotification(this.actions.MERGEMODE.getName(), ImageUtil.getSmallImageIcon("jmeld_mergemode-on"));
        } else {
            StatusBar.getInstance().removeNotification(this.actions.MERGEMODE.getName());
        }
    }

    public void doHelp(ActionEvent ae) {
        try {
            String contentId = "HelpPanel";
            if (this.checkAlreadyOpen(contentId)) {
                return;
            }
            URL url = HelpSet.findHelpSet((ClassLoader)this.getClass().getClassLoader(), (String)"jmeld");
            HelpSet helpSet = new HelpSet(this.getClass().getClassLoader(), url);
            JHelpContentViewer viewer = new JHelpContentViewer(helpSet);
            NavigatorView navigatorView = helpSet.getNavigatorView("TOC");
            JHelpNavigator navigator = (JHelpNavigator)navigatorView.createNavigator((HelpModel)viewer.getModel());
            JSplitPane splitPane = new JSplitPane();
            splitPane.setLeftComponent((Component)navigator);
            splitPane.setRightComponent((Component)viewer);
            AbstractContentPanel content = new AbstractContentPanel();
            content.setId(contentId);
            content.setLayout(new BorderLayout());
            content.add((Component)splitPane, "Center");
            this.getTabbedPane().addTab("Help", ImageUtil.getSmallImageIcon("stock_help-agent"), content);
            this.getTabbedPane().setSelectedComponent(content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void doAbout(ActionEvent ae) {
        String contentId = "AboutPanel";
        if (this.checkAlreadyOpen(contentId)) {
            return;
        }
        AbstractContentPanel content = new AbstractContentPanel();
        content.setId(contentId);
        content.setLayout(new BorderLayout());
        content.add((Component)new JButton("JMeld version: " + Version.getVersion()), "Center");
        this.getTabbedPane().addTab("About", ImageUtil.getSmallImageIcon("stock_about"), content);
        this.getTabbedPane().setSelectedComponent(content);
    }

    public void doExit(ActionEvent ae) {
        if (this.currentBarDialog == this.getSearchBarDialog()) {
            this.doStopSearch(ae);
            return;
        }
        if (this.currentBarDialog != null) {
            this.deactivateBarDialog();
            return;
        }
        AbstractContentPanel cp = this.getCurrentContentPanel();
        if (cp == null) {
            return;
        }
        if (ae.getSource() == this && !cp.checkExit()) {
            return;
        }
        this.doExitTab(this.getCurrentContentPanel());
    }

    public void doSettings(ActionEvent ae) {
        String contentId = "SettingsPanel";
        if (this.checkAlreadyOpen(contentId)) {
            return;
        }
        SettingsPanel content = new SettingsPanel(this);
        content.setId(contentId);
        this.getTabbedPane().addTab("Settings", ImageUtil.getSmallImageIcon("stock_preferences"), content);
        this.getTabbedPane().setSelectedComponent(content);
    }

    private boolean checkAlreadyOpen(String contentId) {
        AbstractContentPanel contentPanel = JMeldPanel.getAlreadyOpen(this.getTabbedPane(), contentId);
        if (contentPanel != null) {
            this.getTabbedPane().setSelectedComponent(contentPanel);
            return true;
        }
        return false;
    }

    public static AbstractContentPanel getAlreadyOpen(JideTabbedPane tabbedPane, String contentId) {
        for (AbstractContentPanel contentPanel : JMeldPanel.getContentPanelList(tabbedPane)) {
            if (!ObjectUtil.equals(contentPanel.getId(), contentId)) continue;
            System.out.println("already open: " + contentId);
            return contentPanel;
        }
        return null;
    }

    private ChangeListener getChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JMeldPanel.this.checkActions();
            }
        };
    }

    public WindowListener getWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                for (JMeldContentPanelIF jMeldContentPanelIF : JMeldPanel.getContentPanelList(JMeldPanel.this.getTabbedPane())) {
                    if (jMeldContentPanelIF.checkSave()) continue;
                    return;
                }
                System.exit(1);
            }
        };
    }

    private AbstractContentPanel getCurrentContentPanel() {
        return (AbstractContentPanel)this.getTabbedPane().getSelectedComponent();
    }

    public static List<AbstractContentPanel> getContentPanelList(JideTabbedPane tabbedPane) {
        ArrayList<AbstractContentPanel> result = new ArrayList<AbstractContentPanel>();
        if (tabbedPane != null) {
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                result.add((AbstractContentPanel)tabbedPane.getComponentAt(i));
            }
        }
        return result;
    }

    private void installKey(boolean enabled, String key, MeldAction action) {
        if (!enabled) {
            this.deInstallKey(key, action);
        } else {
            this.installKey(key, action);
        }
    }

    private void installKey(String key, MeldAction action) {
        SwingUtil.installKey(this, key, action);
    }

    private void deInstallKey(String key, MeldAction action) {
        SwingUtil.deInstallKey(this, key, action);
    }

    private boolean doExitTab(Component component) {
        AbstractContentPanel content;
        if (component == null) {
            return false;
        }
        int index = this.getTabbedPane().indexOfComponent(component);
        if (index == -1) {
            return false;
        }
        if (component instanceof AbstractContentPanel && !(content = (AbstractContentPanel)component).checkSave()) {
            return false;
        }
        Icon icon = this.getTabbedPane().getIconAt(index);
        if (icon != null && icon instanceof TabIcon) {
            ((TabIcon)icon).exit();
        }
        this.getTabbedPane().remove(component);
        return true;
    }

    public void activateBarDialog(AbstractBarDialog bar) {
        this.deactivateBarDialog();
        CellConstraints cc = new CellConstraints();
        this.barContainer.add((Component)bar, cc.xy(1, 1));
        bar.activate();
        this.currentBarDialog = bar;
        this.barContainer.revalidate();
    }

    public void deactivateBarDialog() {
        if (this.currentBarDialog != null) {
            this.barContainer.remove(this.currentBarDialog);
            this.barContainer.revalidate();
            this.currentBarDialog.deactivate();
            this.currentBarDialog = null;
        }
    }

    @Override
    public void configurationChanged() {
        this.checkActions();
    }

    public boolean isStarted() {
        return this.started;
    }
}

