/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jmeld.ui.dnd.DragAndDropPanel;
import org.jmeld.ui.swing.BusyLabel;

public class StatusBar
extends JPanel {
    private static StatusBar instance = new StatusBar();
    private JLabel statusLabel;
    private JPanel progressArea;
    private JProgressBar progressBar;
    private BusyLabel busy;
    private DragAndDropPanel dragAndDrop;
    private Timer timer;
    private JPanel notificationArea;

    private StatusBar() {
        this.setLayout(new BorderLayout());
        this.init();
    }

    public static StatusBar getInstance() {
        return instance;
    }

    private void init() {
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(new EmptyBorder(4, 2, 4, 2));
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5), this.progressBar.getBorder()));
        this.progressBar.setStringPainted(true);
        this.busy = new BusyLabel();
        this.dragAndDrop = new DragAndDropPanel();
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)this.dragAndDrop, "West");
        this.add((Component)this.statusLabel, "Center");
        this.add((Component)panel, "East");
        this.notificationArea = new JPanel(new GridLayout(1, 0));
        this.progressArea = new JPanel(new GridLayout(1, 0));
        panel.add((Component)this.progressArea, "West");
        panel.add((Component)this.notificationArea, "Center");
        panel.add((Component)this.busy, "East");
        this.timer = new Timer(3000, this.clearText());
        this.timer.setRepeats(false);
        this.setMinimumSize(new Dimension(25, 25));
        this.setPreferredSize(new Dimension(25, 25));
    }

    public void start() {
        this.busy.start();
    }

    public void setState(String format, Object ... args) {
        String text = String.format(format, args);
        this.statusLabel.setText(text);
    }

    public void setText(String format, Object ... args) {
        this.setState(format, args);
        this.stop();
    }

    public void setAlarm(String format, Object ... args) {
        this.statusLabel.setForeground(Color.red);
        this.setState(format, args);
        this.stop();
    }

    public void setProgress(int value, int maximum) {
        if (this.progressArea.getComponentCount() == 0) {
            this.progressArea.add(this.progressBar);
            this.revalidate();
        }
        if (this.progressBar.getMaximum() != maximum) {
            this.progressBar.setMaximum(maximum);
        }
        this.progressBar.setValue(value);
        this.progressBar.setString(value + "/" + maximum);
    }

    public void stop() {
        this.timer.restart();
        this.busy.stop();
    }

    private void clear() {
        this.statusLabel.setText("");
        this.statusLabel.setForeground(Color.black);
        this.progressArea.removeAll();
        this.revalidate();
    }

    public void setNotification(String id, ImageIcon icon) {
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.setNotification(id, label);
    }

    public void setNotification(String id, JComponent component) {
        this._setNotification(id, component);
    }

    private void _setNotification(String id, JComponent component) {
        if (this.notificationArea.getClientProperty(id = this.getNotificationId(id)) != null) {
            return;
        }
        this.notificationArea.add(component);
        this.notificationArea.putClientProperty(id, component);
        this.revalidate();
    }

    public void removeNotification(String id) {
        this._removeNotification(id);
    }

    public void _removeNotification(String id) {
        JComponent component = (JComponent)this.notificationArea.getClientProperty(id = this.getNotificationId(id));
        if (component == null) {
            return;
        }
        this.notificationArea.remove(component);
        this.notificationArea.putClientProperty(id, null);
        this.revalidate();
    }

    private String getNotificationId(String id) {
        return "JMeld.notification." + id;
    }

    private ActionListener clearText() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StatusBar.this.clear();
            }
        };
    }
}

