/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.jmeld.util.node.JMDiffNode;

public class UINode
implements TreeTableNode,
Comparable<UINode> {
    private int columnCount;
    private String text;
    private String name;
    private boolean leaf;
    private JMDiffNode diffNode;
    private UINode parent;
    private List<UINode> children = new ArrayList<UINode>();
    private Map<String, UINode> childrenMap = new HashMap<String, UINode>();
    private boolean checkSort;

    public UINode(int columnCount, JMDiffNode diffNode) {
        this(columnCount, diffNode.getName(), diffNode.isLeaf());
        this.diffNode = diffNode;
    }

    public UINode(int columnCount, String name, boolean leaf) {
        assert (name != null);
        this.columnCount = columnCount;
        this.name = name;
        this.leaf = leaf;
    }

    public String getName() {
        return this.name;
    }

    public JMDiffNode getDiffNode() {
        return this.diffNode;
    }

    public UINode addChild(UINode child) {
        UINode c = this.childrenMap.get(child.getName());
        if (c == null) {
            this.childrenMap.put(child.getName(), child);
            this.children.add(child);
            child.setParent(this);
            this.checkSort = true;
            c = child;
        }
        return c;
    }

    private void setParent(UINode parent) {
        this.parent = parent;
    }

    public List<UINode> getChildren() {
        this.checkSort();
        return this.children;
    }

    public Enumeration<UINode> children() {
        this.checkSort();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return this.isLeaf();
    }

    public UINode getChildAt(int childIndex) {
        this.checkSort();
        return this.children.get(childIndex);
    }

    public int getChildCount() {
        this.checkSort();
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        this.checkSort();
        return this.children.indexOf(node);
    }

    public UINode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    private void checkSort() {
        if (this.checkSort) {
            Collections.sort(this.children);
            this.checkSort = false;
        }
    }

    public void print(String indent) {
        System.out.println((String)indent + this.name);
        indent = (String)indent + "  ";
        this.checkSort();
        for (UINode node : this.children) {
            node.print((String)indent);
        }
    }

    public String toString() {
        if (this.text == null) {
            String pn;
            this.text = this.name;
            if (this.parent != null && this.name.startsWith(pn = this.parent.getName())) {
                this.text = this.name.substring(pn.length());
                if (this.text.startsWith(File.separator)) {
                    this.text = this.text.substring(1);
                }
            }
        }
        return this.text;
    }

    @Override
    public int compareTo(UINode o) {
        return this.toString().compareTo(o.toString());
    }

    public Object getValueAt(int column) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean isEditable(int column) {
        return false;
    }

    public void setValueAt(Object aValue, int column) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getUserObject() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setUserObject(Object userObject) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

