/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import com.jidesoft.swing.JideTabbedPane;
import java.io.File;
import javax.swing.JOptionPane;
import org.jdesktop.swingworker.SwingWorker;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.VersionControlPanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.StringUtil;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.file.VersionControlDiff;

public class VersionControlComparison
extends SwingWorker<String, Object> {
    private JMeldPanel mainPanel;
    private File file;
    private VersionControlDiff diff;
    private AbstractContentPanel contentPanel;
    private String contentId;

    public VersionControlComparison(JMeldPanel mainPanel, File file) {
        this.mainPanel = mainPanel;
        this.file = file;
    }

    @Override
    public String doInBackground() {
        if (StringUtil.isEmpty(this.file.getName())) {
            return "file is empty";
        }
        if (!this.file.exists()) {
            return "file(" + this.file.getAbsolutePath() + ") doesn't exist";
        }
        this.contentId = "VersionControlDiffPanel:" + this.file.getName();
        this.contentPanel = JMeldPanel.getAlreadyOpen(this.mainPanel.getTabbedPane(), this.contentId);
        if (this.contentPanel == null) {
            this.diff = new VersionControlDiff(this.file, FolderDiff.Mode.TWO_WAY);
            this.diff.diff();
        }
        return null;
    }

    @Override
    protected void done() {
        try {
            String result = (String)this.get();
            if (result != null) {
                JOptionPane.showMessageDialog(this.mainPanel, result, "Error opening file", 0);
            } else {
                JideTabbedPane tabbedPane = this.mainPanel.getTabbedPane();
                if (tabbedPane != null) {
                    if (this.contentPanel != null) {
                        tabbedPane.setSelectedComponent(this.contentPanel);
                    } else {
                        VersionControlPanel panel = new VersionControlPanel(this.mainPanel, this.diff);
                        panel.setId(this.contentId);
                        tabbedPane.addTab("VCS Comparation", ImageUtil.getSmallImageIcon("stock_folder"), panel);
                        tabbedPane.setSelectedComponent(panel);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

