/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.jmeld.ui.FolderDiffPanel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.VersionControlTreeTableModel;
import org.jmeld.ui.action.MeldAction;
import org.jmeld.ui.swing.DiffLabel;
import org.jmeld.ui.swing.table.JMTreeTable;
import org.jmeld.ui.swing.table.JMTreeTableModel;
import org.jmeld.util.file.VersionControlDiff;
import org.jmeld.vc.VersionControlIF;

public class VersionControlFolderDiffPanel
extends FolderDiffPanel {
    public static final String SEPARATOR = "SEPARATOR";
    protected JComboBox<String> revisionComboBox;

    VersionControlFolderDiffPanel(JMeldPanel mainPanel, VersionControlDiff diff) {
        super(mainPanel, diff);
    }

    public JComboBox<String> getRevisionComboBox() {
        return this.revisionComboBox;
    }

    @Override
    protected void init() {
        VersionControlDiff versionControlDiff = (VersionControlDiff)this.diff;
        File file = versionControlDiff.getFile();
        VersionControlIF versionControl = versionControlDiff.getVersionControl();
        this.revisionComboBox.setModel(new DefaultComboBoxModel<String>(versionControl.getRevisions(file)));
        this.revisionComboBox.addActionListener(new BlockComboListener());
        this.revisionComboBox.setRenderer(new ComboBoxRenderer());
        this.revisionComboBox.setFocusable(false);
        super.init();
    }

    @Override
    protected void initActions() {
        super.initActions();
        MeldAction action = this.actionHandler.createAction(this, this.mainPanel.actions.FOLDER_FILTER);
        this.revisionComboBox.setAction(action);
    }

    @Override
    public void doFilter(ActionEvent ae) {
        this.treeTableModel = null;
        ((VersionControlDiff)this.diff).getVersionControl().setReference((String)this.getRevisionComboBox().getSelectedItem());
        this.diff.diff();
        super.doFilter(ae);
    }

    @Override
    protected void initComponents() {
        this.folder1Label = new DiffLabel();
        this.folder2Label = new DiffLabel();
        this.jScrollPane1 = new JScrollPane();
        this.folderTreeTable = new JMTreeTable();
        this.onlyRightButton = new JToggleButton();
        this.leftRightChangedButton = new JToggleButton();
        this.onlyLeftButton = new JToggleButton();
        this.leftRightUnChangedButton = new JToggleButton();
        this.hierarchyComboBox = new JComboBox();
        this.revisionComboBox = new JComboBox();
        this.expandAllButton = new JButton();
        this.collapseAllButton = new JButton();
        this.deleteLeftButton = new JButton();
        this.copyToLeftButton = new JButton();
        this.copyToRightButton = new JButton();
        this.deleteRightButton = new JButton();
        this.refreshButton = new JButton();
        this.compareButton = new JButton();
        this.folder1Label.setText("Left name of directory");
        this.folder2Label.setText("Right name of directory");
        this.jScrollPane1.setViewportView((Component)((Object)this.folderTreeTable));
        this.onlyRightButton.setText("R");
        this.leftRightChangedButton.setText("LR");
        this.onlyLeftButton.setText("L");
        this.leftRightUnChangedButton.setText("Un");
        this.hierarchyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.revisionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.expandAllButton.setText("Exp");
        this.collapseAllButton.setText("Col");
        this.deleteLeftButton.setText("DL");
        this.deleteLeftButton.setMargin(new Insets(2, 2, 2, 2));
        this.copyToLeftButton.setText("CL");
        this.copyToLeftButton.setMargin(new Insets(2, 2, 2, 2));
        this.copyToRightButton.setText("CR");
        this.copyToRightButton.setMargin(new Insets(2, 2, 2, 2));
        this.deleteRightButton.setText("DR");
        this.deleteRightButton.setMargin(new Insets(2, 2, 2, 2));
        this.refreshButton.setText("RS");
        this.refreshButton.setMargin(new Insets(2, 2, 2, 2));
        this.compareButton.setText("CO");
        this.compareButton.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.folder1Label, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.expandAllButton).addPreferredGap(0).add((Component)this.collapseAllButton).addPreferredGap(0).add((Component)this.hierarchyComboBox, -2, -1, -2).add(this.revisionComboBox, -2, -1, -2))).addPreferredGap(0).add((Component)this.compareButton).addPreferredGap(0).add((Component)this.refreshButton).add(59, 59, 59).add((Component)this.deleteLeftButton).addPreferredGap(0).add((Component)this.copyToLeftButton).add(18, 18, 18).add((Component)this.copyToRightButton).addPreferredGap(0).add((Component)this.deleteRightButton).addPreferredGap(0, 199, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.onlyLeftButton).addPreferredGap(0).add((Component)this.leftRightChangedButton).addPreferredGap(0).add((Component)this.onlyRightButton).addPreferredGap(0).add((Component)this.leftRightUnChangedButton)).add((Component)this.folder2Label, -2, -1, -2))).add((Component)this.jScrollPane1, -1, 875, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.leftRightChangedButton, this.leftRightUnChangedButton, this.onlyLeftButton, this.onlyRightButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.folder1Label, -2, -1, -2).add((Component)this.folder2Label, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.expandAllButton).add((Component)this.collapseAllButton).add((Component)this.hierarchyComboBox, -2, -1, -2).add(this.revisionComboBox, -2, -1, -2).add((Component)this.compareButton).add((Component)this.refreshButton).add((Component)this.deleteLeftButton).add((Component)this.copyToLeftButton).add((Component)this.copyToRightButton).add((Component)this.deleteRightButton).add((Component)this.onlyLeftButton).add((Component)this.leftRightChangedButton).add((Component)this.onlyRightButton).add((Component)this.leftRightUnChangedButton)).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 362, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    protected JMTreeTableModel createTreeTableModel() {
        return new VersionControlTreeTableModel();
    }

    class BlockComboListener
    implements ActionListener {
        Object currentItem = 0;

        BlockComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox combo = (JComboBox)e.getSource();
            String tempItem = (String)combo.getSelectedItem();
            if (VersionControlFolderDiffPanel.SEPARATOR.equals(tempItem)) {
                if (this.currentItem != null) {
                    combo.setSelectedItem(this.currentItem);
                }
            } else {
                this.currentItem = tempItem;
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        JSeparator separator;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.separator = new JSeparator(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            String string = str = value == null ? "" : value;
            if (VersionControlFolderDiffPanel.SEPARATOR.equals(str)) {
                return this.separator;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(str);
            return this;
        }
    }
}

