/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.jmeld.JMeldException;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.VersionControlFolderDiffPanel;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.file.VersionControlDiff;
import org.jmeld.util.node.JMDiffNode;

public class VersionControlPanel
extends AbstractContentPanel
implements ConfigurationListenerIF {
    private JMeldPanel mainPanel;
    private VersionControlDiff diff;

    public VersionControlPanel(JMeldPanel mainPanel, VersionControlDiff diff) {
        this.mainPanel = mainPanel;
        this.diff = diff;
        this.init();
    }

    private void init() {
        final JSplitPane splitPane = new JSplitPane(0);
        VersionControlFolderDiffPanel versionControlFolderDiffPanel = new VersionControlFolderDiffPanel(this.mainPanel, this.diff){

            @Override
            protected void openInContext(JMDiffNode diffNode) throws JMeldException {
                BufferDiffPanel panel = new BufferDiffPanel(this.mainPanel);
                panel.setId("context diff");
                diffNode.diff();
                panel.setDiffNode(diffNode);
                panel.doGoToFirst();
                splitPane.setBottomComponent(panel);
                splitPane.setDividerLocation(0.5);
                splitPane.updateUI();
            }

            @Override
            public void doFilter(ActionEvent ae) {
                super.doFilter(ae);
                int row = this.folderDiffMouseAdapter.getRow();
                if (row >= 0) {
                    this.openFileOnRow(row, true, false);
                } else {
                    splitPane.setBottomComponent(new JPanel());
                    splitPane.setDividerLocation(1.0);
                    splitPane.updateUI();
                }
            }
        };
        splitPane.setTopComponent(versionControlFolderDiffPanel);
        splitPane.updateUI();
        this.setLayout(new BorderLayout());
        this.add("Center", splitPane);
    }

    @Override
    public void configurationChanged() {
    }
}

