/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.action;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.jmeld.ui.action.ActionHandler;
import org.jmeld.ui.util.ImageUtil;

public class MeldAction
extends AbstractAction {
    public static String LARGE_ICON_KEY = "SwingLargeIconKey";
    private Object object;
    private Method actionMethod;
    private Method isActionEnabledMethod;
    private ActionHandler actionHandler;

    MeldAction(ActionHandler actionHandler, Object object, String name) {
        super(name);
        this.actionHandler = actionHandler;
        this.object = object;
        this.initMethods();
    }

    private void initMethods() {
        try {
            this.actionMethod = this.object.getClass().getMethod("do" + this.getName(), ActionEvent.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        try {
            this.isActionEnabledMethod = this.object.getClass().getMethod("is" + this.getName() + "Enabled", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setToolTip(String toolTip) {
        this.putValue("ShortDescription", toolTip);
    }

    public void setIcon(String iconName) {
        this.putValue("SmallIcon", ImageUtil.getSmallImageIcon(iconName));
        this.putValue(LARGE_ICON_KEY, ImageUtil.getImageIcon(iconName));
    }

    public ImageIcon getTransparentSmallImageIcon() {
        return ImageUtil.createTransparentIcon((ImageIcon)this.getValue("SmallIcon"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.object == null || this.actionMethod == null) {
            System.out.println("setActionCommand() has not been executed!");
            return;
        }
        try {
            this.actionMethod.setAccessible(true);
            this.actionMethod.invoke(this.object, ae);
            this.actionHandler.checkActions();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isActionEnabled() {
        if (this.object == null || this.isActionEnabledMethod == null) {
            return true;
        }
        try {
            return (Boolean)this.isActionEnabledMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return true;
    }
}

