/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.diffbar;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.ui.util.RevisionUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class DiffScrollComponent
extends JComponent
implements ChangeListener,
ConfigurationListenerIF {
    private BufferDiffPanel diffPanel;
    private int fromPanelIndex;
    private int toPanelIndex;
    private List<Command> commands;
    private Object antiAlias;
    private boolean leftsideReadonly;
    private boolean rightsideReadonly;
    private int curveType;
    private boolean drawCurves;
    boolean shift;

    public DiffScrollComponent(BufferDiffPanel diffPanel, int fromPanelIndex, int toPanelIndex) {
        this.diffPanel = diffPanel;
        this.fromPanelIndex = fromPanelIndex;
        this.toPanelIndex = toPanelIndex;
        this.getFromPanel().getScrollPane().getViewport().addChangeListener(this);
        this.getToPanel().getScrollPane().getViewport().addChangeListener(this);
        this.addMouseListener(this.getMouseListener());
        this.addMouseWheelListener(this.getMouseWheelListener());
        this.addKeyListener(this.getKeyListener());
        JMeldSettings.getInstance().addConfigurationListener(this);
        this.initSettings();
    }

    public void setCurveType(int curveType) {
        this.curveType = curveType;
    }

    public int getCurveType() {
        return this.curveType;
    }

    public void setShift(boolean shift) {
        this.shift = shift;
        this.repaint();
    }

    public KeyListener getKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    DiffScrollComponent.this.shift = true;
                    DiffScrollComponent.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 16) {
                    DiffScrollComponent.this.shift = false;
                    DiffScrollComponent.this.repaint();
                }
            }
        };
    }

    public boolean isDrawCurves() {
        return this.drawCurves;
    }

    public void setDrawCurves(boolean drawCurves) {
        this.drawCurves = drawCurves;
    }

    private void initSettings() {
        JMeldSettings settings = JMeldSettings.getInstance();
        EditorSettings editorSettings = settings.getEditor();
        this.leftsideReadonly = editorSettings.getLeftsideReadonly();
        this.rightsideReadonly = editorSettings.getRightsideReadonly();
        this.setDrawCurves(settings.getDrawCurves());
        this.setCurveType(settings.getCurveType());
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.repaint();
    }

    @Override
    public void configurationChanged() {
        this.initSettings();
        this.repaint();
    }

    private MouseWheelListener getMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent me) {
                DiffScrollComponent.this.diffPanel.toNextDelta(me.getWheelRotation() > 0);
                DiffScrollComponent.this.repaint();
            }
        };
    }

    private MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                DiffScrollComponent.this.requestFocus();
                int onmask = 64;
                int offmask = 128;
                boolean shift = false;
                if ((me.getModifiersEx() & (onmask | offmask)) == onmask) {
                    shift = true;
                }
                DiffScrollComponent.this.executeCommand(me.getX(), me.getY(), shift);
            }
        };
    }

    public boolean executeCommand(double x, double y, boolean shift) {
        if (this.commands == null) {
            return false;
        }
        for (Command command : this.commands) {
            if (!command.contains(x, y)) continue;
            command.execute(shift);
            return true;
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = g.getClipBounds();
        g2.setColor(this.getBackground());
        g2.fill(r);
        int middle = r.height / 2;
        g2.setColor(Color.LIGHT_GRAY);
        Stroke oldStroke = g2.getStroke();
        this.paintDiffs(g2);
    }

    private void paintDiffs(Graphics2D g2) {
        Rectangle bounds = g2.getClipBounds();
        g2.setClip(null);
        JMRevision revision = this.diffPanel.getCurrentRevision();
        if (revision == null) {
            return;
        }
        this.commands = new ArrayList<Command>();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.antiAlias = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        FilePanel fromPanel = this.getFromPanel();
        JViewport viewportFrom = fromPanel.getScrollPane().getViewport();
        JTextArea editorFrom = fromPanel.getEditor();
        BufferDocumentIF bdFrom = fromPanel.getBufferDocument();
        if (bdFrom == null) {
            return;
        }
        Rectangle r = viewportFrom.getViewRect();
        Point p = new Point(r.x, r.y);
        int offset = editorFrom.viewToModel(p);
        int firstLineFrom = bdFrom.getLineForOffset(offset) + 1;
        p = new Point(r.x, r.y + r.height);
        offset = editorFrom.viewToModel(p);
        bdFrom = fromPanel.getBufferDocument();
        int lastLineFrom = bdFrom.getLineForOffset(offset) + 1;
        FilePanel toPanel = this.getToPanel();
        JViewport viewportTo = toPanel.getScrollPane().getViewport();
        JTextArea editorTo = toPanel.getEditor();
        BufferDocumentIF bdTo = toPanel.getBufferDocument();
        if (bdTo == null) {
            return;
        }
        r = viewportTo.getViewRect();
        p = new Point(r.x, r.y);
        offset = editorTo.viewToModel(p);
        int firstLineTo = bdTo.getLineForOffset(offset) + 1;
        p = new Point(r.x, r.y + r.height);
        offset = editorTo.viewToModel(p);
        int lastLineTo = bdTo.getLineForOffset(offset) + 1;
        try {
            for (JMDelta delta : revision.getDeltas()) {
                JMChunk original = delta.getOriginal();
                JMChunk revised = delta.getRevised();
                if (original.getAnchor() + original.getSize() < firstLineFrom && revised.getAnchor() + revised.getSize() < firstLineTo) continue;
                if (original.getAnchor() <= lastLineFrom || revised.getAnchor() <= lastLineTo) {
                    Rectangle rect;
                    Polygon shape;
                    boolean drawCommandPointers;
                    boolean selected = delta == this.diffPanel.getSelectedDelta();
                    Color color = RevisionUtil.getColor(delta);
                    Color darkerColor = RevisionUtil.getDarkerColor(delta);
                    g2.setColor(color);
                    int fromLine = original.getAnchor();
                    int toLine = original.getAnchor() + original.getSize();
                    Rectangle viewportRect = viewportFrom.getViewRect();
                    offset = bdFrom.getOffsetForLine(fromLine);
                    if (offset < 0) continue;
                    Rectangle fromRect = editorFrom.modelToView(offset);
                    offset = bdFrom.getOffsetForLine(toLine);
                    if (offset < 0) continue;
                    Rectangle toRect = editorFrom.modelToView(offset);
                    int x = 0;
                    int y = fromRect.y - viewportRect.y + 1;
                    y = y < 0 ? 0 : y;
                    int width = 10;
                    int height = 0;
                    if (fromRect.y <= viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = original.getSize() * fromRect.height;
                        height -= viewportRect.y - fromRect.y;
                    } else if (fromRect.y > viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = original.getSize() * fromRect.height;
                        height -= viewportRect.y + viewportRect.height - toRect.y;
                    } else if (fromRect.y > viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = original.getSize() * fromRect.height;
                    } else if (fromRect.y <= viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = viewportRect.height;
                    }
                    int x0 = x + width;
                    int y0 = y;
                    int curveX1 = x;
                    int curveY1 = y;
                    int curveX4 = x;
                    int curveY4 = y + (height > 0 ? height : 0);
                    int xSelFrom = x;
                    int ySelFrom = y;
                    int heightSelFrom = height;
                    fromLine = revised.getAnchor();
                    toLine = revised.getAnchor() + revised.getSize();
                    viewportRect = viewportTo.getViewRect();
                    offset = bdTo.getOffsetForLine(fromLine);
                    if (offset < 0) continue;
                    fromRect = editorTo.modelToView(offset);
                    offset = bdTo.getOffsetForLine(toLine);
                    if (offset < 0) continue;
                    toRect = editorTo.modelToView(offset);
                    x = bounds.x + bounds.width - 10;
                    y = fromRect.y - viewportRect.y + 1;
                    y = y < 0 ? 0 : y;
                    width = 10;
                    height = 0;
                    if (fromRect.y <= viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = revised.getSize() * fromRect.height;
                        height -= viewportRect.y - fromRect.y;
                    } else if (fromRect.y > viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = revised.getSize() * fromRect.height;
                        height -= viewportRect.y + viewportRect.height - toRect.y;
                    } else if (fromRect.y > viewportRect.y && toRect.y <= viewportRect.y + viewportRect.height) {
                        height = revised.getSize() * fromRect.height;
                    } else if (fromRect.y <= viewportRect.y && toRect.y > viewportRect.y + viewportRect.height) {
                        height = viewportRect.height;
                    }
                    int x1 = x;
                    int y1 = y;
                    if (this.isDrawCurves()) {
                        int curveX2 = x + width;
                        int curveY2 = y;
                        int curveX3 = x + width;
                        int curveY3 = y + (height > 0 ? height : 0);
                        GeneralPath curve = new GeneralPath();
                        if (this.getCurveType() == 0) {
                            curve.append(new Line2D.Float(curveX4, curveY4, curveX1, curveY1), true);
                            curve.append(new Line2D.Float(curveX2, curveY2, curveX3, curveY3), true);
                        } else if (this.getCurveType() == 1) {
                            int posyOrg = original.getSize() > 0 ? 0 : 1;
                            int posyRev = revised.getSize() > 0 ? 0 : 1;
                            curve.append(new CubicCurve2D.Float(curveX1, curveY1 - posyOrg, curveX1 + (curveX2 - curveX1) / 2 + 5, curveY1, curveX1 + (curveX2 - curveX1) / 2 + 5, curveY2, curveX2, curveY2 - posyRev), true);
                            boolean addHeightCorrection = false;
                            curve.append(new CubicCurve2D.Float(curveX3, curveY3 + posyRev, curveX3 + (curveX4 - curveX3) / 2 - 5, curveY3, curveX3 + (curveX4 - curveX3) / 2 - 5, curveY4, curveX4, curveY4 + posyOrg), true);
                        } else if (this.getCurveType() == 2) {
                            curve.append(new CubicCurve2D.Float(curveX1, curveY1 - 2, curveX2 + 10, curveY1, curveX1 + 10, curveY2, curveX2, curveY2 - 2), true);
                            curve.append(new CubicCurve2D.Float(curveX3, curveY3 + 2, curveX4 - 10, curveY3, curveX3 - 10, curveY4, curveX4, curveY4 + 2), true);
                        }
                        g2.setColor(color);
                        g2.fill(curve);
                        g2.setColor(darkerColor);
                        this.setAntiAlias(g2);
                        g2.draw(curve);
                        this.resetAntiAlias(g2);
                    } else {
                        if (height > 0) {
                            g2.setColor(color);
                            g2.fillRect(x, y, width, height);
                        }
                        g2.setColor(darkerColor);
                        g2.drawLine(x, y, x + width, y);
                        if (height > 0) {
                            g2.drawLine(x, y + height, x + width, y + height);
                            g2.drawLine(x, y, x, y + height);
                        }
                        g2.setColor(darkerColor);
                        g2.drawLine(x0, y0, x0 + 15, y0);
                        this.setAntiAlias(g2);
                        g2.drawLine(x0 + 15, y0, x1 - 15, y1);
                        this.resetAntiAlias(g2);
                        g2.drawLine(x1 - 15, y1, x1, y1);
                    }
                    boolean showSelected = true;
                    if (showSelected && selected) {
                        int selectionWidth;
                        if (heightSelFrom > 0) {
                            selectionWidth = 5;
                            g2.setColor(Color.yellow);
                            g2.fillRect(xSelFrom, ySelFrom, selectionWidth, heightSelFrom);
                            g2.setColor(Color.yellow.darker());
                            g2.drawLine(xSelFrom, ySelFrom, xSelFrom + selectionWidth, ySelFrom);
                            g2.drawLine(xSelFrom + selectionWidth, ySelFrom, xSelFrom + selectionWidth, ySelFrom + heightSelFrom);
                            g2.drawLine(xSelFrom, ySelFrom + heightSelFrom, xSelFrom + selectionWidth, ySelFrom + heightSelFrom);
                        }
                        if (height > 0) {
                            selectionWidth = 5;
                            g2.setColor(Color.yellow);
                            g2.fillRect(x += selectionWidth, y, selectionWidth, height);
                            g2.setColor(Color.yellow.darker());
                            g2.drawLine(x, y, x + selectionWidth, y);
                            g2.drawLine(x, y, x, y + height);
                            g2.drawLine(x, y + height, x + selectionWidth, y + height);
                            g2.setColor(color);
                        }
                    }
                    if (!(drawCommandPointers = true)) continue;
                    if (!this.leftsideReadonly && !bdFrom.isReadonly()) {
                        if (!this.shift || revised.getSize() > 0) {
                            shape = this.createTriangle(x0, y0, true);
                            this.setAntiAlias(g2);
                            g2.setColor(this.shift ? Color.black : color);
                            g2.fill(shape);
                            g2.setColor(this.shift ? Color.black : darkerColor);
                            g2.draw(shape);
                            this.resetAntiAlias(g2);
                            this.commands.add(new DiffChangeCommand(shape, delta, this.toPanelIndex, this.fromPanelIndex));
                        }
                        if (original.getSize() > 0 && !this.shift) {
                            g2.setColor(Color.red);
                            g2.drawLine(x0 + 3 - width, y0 + 3, x0 + 7 - width, y0 + 7);
                            g2.drawLine(x0 + 7 - width, y0 + 3, x0 + 3 - width, y0 + 7);
                            rect = new Rectangle(x0 + 2 - width, y0 + 2, 6, 6);
                            this.commands.add(new DiffDeleteCommand(rect, delta, this.fromPanelIndex, this.toPanelIndex));
                        }
                    }
                    if (this.rightsideReadonly || bdTo.isReadonly()) continue;
                    if (!this.shift || original.getSize() > 0) {
                        shape = this.createTriangle(x1, y1, false);
                        this.setAntiAlias(g2);
                        g2.setColor(this.shift ? Color.black : color);
                        g2.fillPolygon(shape);
                        g2.setColor(this.shift ? Color.black : darkerColor);
                        g2.drawPolygon(shape);
                        this.resetAntiAlias(g2);
                        this.commands.add(new DiffChangeCommand(shape, delta, this.fromPanelIndex, this.toPanelIndex));
                    }
                    if (revised.getSize() <= 0 || this.shift) continue;
                    g2.setColor(Color.red);
                    g2.drawLine(x1 + 3, y1 + 3, x1 + 7, y1 + 7);
                    g2.drawLine(x1 + 7, y1 + 3, x1 + 3, y1 + 7);
                    rect = new Rectangle(x1 + 2, y1 + 2, 6, 6);
                    this.commands.add(new DiffDeleteCommand(rect, delta, this.toPanelIndex, this.fromPanelIndex));
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        this.resetAntiAlias(g2);
    }

    private Polygon createTriangle(int x, int y, boolean toLeft) {
        Polygon shape = new Polygon();
        int posx = 10;
        shape.addPoint(x + (toLeft ? -posx : posx), y);
        shape.addPoint(x + (toLeft ? -posx : (posx -= 11)), y + -4);
        shape.addPoint(x + (toLeft ? -posx : posx), y + 4);
        return shape;
    }

    private void setAntiAlias(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private void resetAntiAlias(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antiAlias);
    }

    private FilePanel getFromPanel() {
        return this.diffPanel.getFilePanel(this.fromPanelIndex);
    }

    private FilePanel getToPanel() {
        return this.diffPanel.getFilePanel(this.toPanelIndex);
    }

    abstract class Command {
        Rectangle bounds;
        JMDelta delta;
        int fromIndex;
        int toIndex;

        Command(Shape shape, JMDelta delta, int fromIndex, int toIndex) {
            this.bounds = shape.getBounds();
            this.delta = delta;
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        boolean contains(double x, double y) {
            return this.bounds.contains(x, y);
        }

        public abstract void execute(boolean var1);
    }

    class DiffDeleteCommand
    extends Command {
        DiffDeleteCommand(Shape shape, JMDelta delta, int fromIndex, int toIndex) {
            super(shape, delta, fromIndex, toIndex);
        }

        @Override
        public void execute(boolean shift) {
            DiffScrollComponent.this.diffPanel.setSelectedDelta(this.delta);
            if (!shift) {
                DiffScrollComponent.this.diffPanel.runDelete(this.fromIndex, this.toIndex);
            }
        }
    }

    class DiffChangeCommand
    extends Command {
        DiffChangeCommand(Shape shape, JMDelta delta, int fromIndex, int toIndex) {
            super(shape, delta, fromIndex, toIndex);
        }

        @Override
        public void execute(boolean shift) {
            DiffScrollComponent.this.diffPanel.setSelectedDelta(this.delta);
            DiffScrollComponent.this.diffPanel.runChange(this.fromIndex, this.toIndex, shift);
        }
    }
}

