/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.search;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jmeld.ui.AbstractBarDialog;
import org.jmeld.ui.JMeldPanel;
import org.jmeld.ui.search.SearchCommand;
import org.jmeld.ui.search.SearchHits;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.StringUtil;

public class SearchBarDialog
extends AbstractBarDialog {
    private static final String CP_FOREGROUND = "JMeld.foreground";
    private static final String CP_BACKGROUND = "JMeld.background";
    private JTextField searchField;
    private JLabel searchResult;
    private Timer timer;

    public SearchBarDialog(JMeldPanel meldPanel) {
        super(meldPanel);
    }

    @Override
    protected void init() {
        this.setLayout(new FlowLayout(3));
        JButton closeButton = new JButton(ImageUtil.getImageIcon("jmeld_close"));
        closeButton.setRolloverIcon(ImageUtil.getImageIcon("jmeld_close-rollover"));
        closeButton.setPressedIcon(ImageUtil.getImageIcon("jmeld_close-pressed"));
        closeButton.addActionListener(this.getCloseAction());
        this.initButton(closeButton);
        closeButton.setBorder(null);
        this.searchField = new JTextField(15);
        this.searchField.getDocument().addDocumentListener(this.getSearchAction());
        this.searchField.addKeyListener(this.getSearchKeyAction());
        JButton previousButton = new JButton("Previous", ImageUtil.getImageIcon("stock_data-previous"));
        previousButton.addActionListener(this.getPreviousAction());
        this.initButton(previousButton);
        JButton nextButton = new JButton("Next", ImageUtil.getImageIcon("stock_data-next"));
        nextButton.addActionListener(this.getNextAction());
        this.initButton(nextButton);
        this.searchResult = new JLabel();
        this.initButton(previousButton);
        this.add(closeButton);
        this.add(Box.createHorizontalStrut(5));
        this.add(new JLabel("Find:"));
        this.add(this.searchField);
        this.add(previousButton);
        this.add(nextButton);
        this.add(Box.createHorizontalStrut(10));
        this.add(this.searchResult);
        this.timer = new Timer(500, this.executeSearch());
        this.timer.setRepeats(false);
    }

    private void initButton(AbstractButton button) {
        button.setFocusable(false);
        button.setBorderPainted(false);
        button.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    public SearchCommand getCommand() {
        return new SearchCommand(this.searchField.getText(), false);
    }

    public void setSearchText(String searchText) {
        if (StringUtil.isEmpty(searchText)) {
            return;
        }
        if (searchText.length() > 50) {
            return;
        }
        this.searchField.setText(searchText);
    }

    @Override
    public void _activate() {
        this.searchField.requestFocus();
        this.searchField.selectAll();
        if (!StringUtil.isEmpty(this.searchField.getText())) {
            this.timer.restart();
        }
    }

    @Override
    public void _deactivate() {
    }

    private DocumentListener getSearchAction() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchBarDialog.this.timer.restart();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchBarDialog.this.timer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchBarDialog.this.timer.restart();
            }
        };
    }

    private ActionListener executeSearch() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean notFound;
                String searchText = SearchBarDialog.this.searchField.getText();
                SearchHits searchHits = SearchBarDialog.this.getMeldPanel().doSearch(null);
                boolean bl = notFound = searchHits == null || searchHits.getSearchHits().size() == 0;
                if (notFound) {
                    if (SearchBarDialog.this.searchField.getForeground() != Color.red) {
                        SearchBarDialog.this.searchField.putClientProperty(SearchBarDialog.CP_FOREGROUND, SearchBarDialog.this.searchField.getForeground());
                        SearchBarDialog.this.searchField.setForeground(Color.red);
                    }
                    SearchBarDialog.this.searchResult.setIcon(ImageUtil.getImageIcon("bullet-warning"));
                    SearchBarDialog.this.searchResult.setText("Phrase not found");
                } else {
                    Color color = (Color)SearchBarDialog.this.searchField.getClientProperty(SearchBarDialog.CP_FOREGROUND);
                    if (color != null) {
                        SearchBarDialog.this.searchField.setForeground(color);
                        SearchBarDialog.this.searchField.putClientProperty(SearchBarDialog.CP_FOREGROUND, null);
                    }
                    if (!StringUtil.isEmpty(SearchBarDialog.this.searchResult.getText())) {
                        SearchBarDialog.this.searchResult.setIcon(null);
                        SearchBarDialog.this.searchResult.setText("");
                    }
                }
            }
        };
    }

    private KeyListener getSearchKeyAction() {
        return new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchBarDialog.this.getMeldPanel().doNextSearch(null);
                }
            }
        };
    }

    private ActionListener getCloseAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchBarDialog.this.getMeldPanel().doStopSearch(null);
            }
        };
    }

    private ActionListener getPreviousAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchBarDialog.this.getMeldPanel().doPreviousSearch(null);
            }
        };
    }

    private ActionListener getNextAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchBarDialog.this.getMeldPanel().doNextSearch(null);
            }
        };
    }
}

