/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.settings;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import org.jmeld.settings.FolderSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.settings.FolderSettingsForm;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class FolderSettingsPanel
extends FolderSettingsForm
implements ConfigurationListenerIF {
    public FolderSettingsPanel() {
        this.init();
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    private void init() {
        FolderSettings settings = this.getSettings();
        this.hierarchyComboBox.setModel(new DefaultComboBoxModel<FolderSettings.FolderView>(FolderSettings.FolderView.values()));
        this.hierarchyComboBox.setSelectedItem((Object)this.getSettings().getView());
        this.hierarchyComboBox.setFocusable(false);
        this.hierarchyComboBox.addActionListener(this.getHierarchyAction());
        this.onlyLeftButton.setText(null);
        this.onlyLeftButton.setIcon(ImageUtil.getImageIcon("jmeld_only-left"));
        this.onlyLeftButton.setFocusable(false);
        this.onlyLeftButton.setSelected(settings.getOnlyLeft());
        this.onlyLeftButton.addActionListener(this.getOnlyLeftAction());
        this.leftRightChangedButton.setText(null);
        this.leftRightChangedButton.setIcon(ImageUtil.getImageIcon("jmeld_left-right-changed"));
        this.leftRightChangedButton.setFocusable(false);
        this.leftRightChangedButton.setSelected(settings.getLeftRightChanged());
        this.leftRightChangedButton.addActionListener(this.getLeftRightChangedAction());
        this.onlyRightButton.setText(null);
        this.onlyRightButton.setIcon(ImageUtil.getImageIcon("jmeld_only-right"));
        this.onlyRightButton.setFocusable(false);
        this.onlyRightButton.setSelected(settings.getOnlyRight());
        this.onlyRightButton.addActionListener(this.getOnlyRightAction());
        this.leftRightUnChangedButton.setText(null);
        this.leftRightUnChangedButton.setIcon(ImageUtil.getImageIcon("jmeld_left-right-unchanged"));
        this.leftRightUnChangedButton.setFocusable(false);
        this.leftRightUnChangedButton.setSelected(settings.getLeftRightUnChanged());
        this.leftRightUnChangedButton.addActionListener(this.getLeftRightUnChangedAction());
    }

    private ActionListener getHierarchyAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderSettingsPanel.this.getSettings().setView((FolderSettings.FolderView)((Object)FolderSettingsPanel.this.hierarchyComboBox.getSelectedItem()));
            }
        };
    }

    private ActionListener getOnlyLeftAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderSettingsPanel.this.getSettings().setOnlyLeft(FolderSettingsPanel.this.onlyLeftButton.isSelected());
            }
        };
    }

    private ActionListener getLeftRightChangedAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderSettingsPanel.this.getSettings().setLeftRightChanged(FolderSettingsPanel.this.leftRightChangedButton.isSelected());
            }
        };
    }

    private ActionListener getOnlyRightAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderSettingsPanel.this.getSettings().setOnlyRight(FolderSettingsPanel.this.onlyRightButton.isSelected());
            }
        };
    }

    private ActionListener getLeftRightUnChangedAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FolderSettingsPanel.this.getSettings().setLeftRightUnChanged(FolderSettingsPanel.this.leftRightUnChangedButton.isSelected());
            }
        };
    }

    @Override
    public void configurationChanged() {
    }

    private FolderSettings getSettings() {
        return JMeldSettings.getInstance().getFolder();
    }
}

