/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMDiff;
import org.jmeld.diff.JMRevision;
import org.jmeld.util.Ignore;
import org.jmeld.util.Tokenizer;
import org.jmeld.util.TokenizerFactory;

public class DiffLabel
extends JTextPane {
    public DiffLabel() {
        this.init();
    }

    public void init() {
        this.setEditable(false);
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setBorder(null);
        Style defaultStyle = this.getStyle("default");
        StyledDocument doc = this.getStyledDocument();
        Style s = doc.addStyle("bold", defaultStyle);
        StyleConstants.setBold(s, true);
    }

    public void setText(String text, String otherText) {
        try {
            Tokenizer wt = TokenizerFactory.getInstance().getFileNameTokenizer();
            List<String> textList = wt.getTokens(text);
            List<String> otherTextList = wt.getTokens(otherText);
            String[] styles = new String[textList.size()];
            if (otherTextList.size() != 0) {
                JMRevision revision = new JMDiff().diff(textList, otherTextList, Ignore.NULL_IGNORE);
                for (JMDelta delta : revision.getDeltas()) {
                    JMChunk chunk = delta.getOriginal();
                    for (int i = 0; i < chunk.getSize(); ++i) {
                        styles[chunk.getAnchor() + i] = "bold";
                    }
                }
            }
            StyledDocument doc = this.getStyledDocument();
            doc.remove(0, doc.getLength());
            for (int i = 0; i < textList.size(); ++i) {
                doc.insertString(doc.getLength(), textList.get(i), styles[i] != null ? doc.getStyle(styles[i]) : null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setText(text);
        }
    }
}

