/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;
import org.jmeld.ui.util.Colors;

public class GradientLabel
extends JLabel {
    private Color fromColor;
    private Color toColor;

    public GradientLabel(String text) {
        super(text);
        this.initialize();
    }

    private void initialize() {
        this.setOpaque(false);
        this.setGradientColor(Colors.getDarkLookAndFeelColor());
        this.setForeground(Color.white);
    }

    public GradientLabel() {
        this.initialize();
    }

    public void setGradientColor(Color fromColor) {
        this.setGradientColor(fromColor, new Color(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue(), 0));
    }

    public void setGradientColor(Color fromColor, Color toColor) {
        this.fromColor = fromColor;
        this.toColor = toColor;
    }

    public Color getFromColor() {
        return this.fromColor;
    }

    public Color getToColor() {
        return this.toColor;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = this.getBounds();
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.fromColor, (int)((double)r.width / 1.1), r.height, this.toColor);
        g2.setPaint(paint);
        g2.fillRect(0, 0, r.width, r.height);
        super.paint(g);
    }
}

