/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jmeld.ui.swing.JMHighlightPainter;

public class JMHighlightNewLinePainter
extends JMHighlightPainter {
    protected JMHighlightNewLinePainter(Color color) {
        super(color);
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape shape, JTextComponent comp) {
        Rectangle b = shape.getBounds();
        try {
            Rectangle r1 = comp.modelToView(p0);
            Rectangle r2 = comp.modelToView(p1);
            g.setColor(this.color);
            if (this == CHANGED_LIGHTER || this == SEARCH || this == CURRENT_SEARCH) {
                if (r1.y == r2.y) {
                    g.fillRect(r1.x, r1.y, r2.x - r1.x, r1.height);
                } else {
                    int count = (r2.y - r1.y) / r1.height + 1;
                    int y = r1.y;
                    int i = 0;
                    while (i < count) {
                        int width;
                        int x;
                        if (i == 0) {
                            x = r1.x;
                            width = b.width - b.x;
                        } else if (i == count - 1) {
                            x = b.x;
                            width = r2.x - x;
                        } else {
                            x = b.x;
                            width = b.width - b.x;
                        }
                        g.fillRect(x, y, width, r1.height);
                        ++i;
                        y += r1.height;
                    }
                }
            } else {
                int height = r2.y - r1.y;
                g.fillRect(0, r1.y, b.x + b.width, height += r1.height);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }
}

