/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import org.jmeld.settings.EditorSettings;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.swing.JMHighlightLinePainter;
import org.jmeld.ui.swing.JMHighlightNewLinePainter;
import org.jmeld.ui.util.Colors;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class JMHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter
implements ConfigurationListenerIF {
    public static final JMHighlightPainter ADDED = new JMHighlightPainter(Colors.ADDED);
    public static final JMHighlightPainter ADDED_LINE;
    public static final JMHighlightPainter ADDED_NEWLINE;
    public static final JMHighlightPainter CHANGED;
    public static final JMHighlightPainter CHANGED_NEWLINE;
    public static final JMHighlightPainter CHANGED_LIGHTER;
    public static final JMHighlightPainter DELETED;
    public static final JMHighlightPainter DELETED_LINE;
    public static final JMHighlightPainter DELETED_NEWLINE;
    public static final JMHighlightPainter CURRENT_SEARCH;
    public static final JMHighlightPainter SEARCH;
    protected Color color;

    protected JMHighlightPainter(Color color) {
        super(color);
        this.color = color;
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape shape, JTextComponent comp) {
        Rectangle b = shape.getBounds();
        try {
            Rectangle r1 = comp.modelToView(p0);
            Rectangle r2 = comp.modelToView(p1);
            g.setColor(this.color);
            if (this.isChangeLighter() || this.isSearch()) {
                if (r1.y == r2.y) {
                    g.fillRect(r1.x, r1.y, r2.x - r1.x, r1.height);
                } else {
                    int count = (r2.y - r1.y) / r1.height + 1;
                    int y = r1.y;
                    int i = 0;
                    while (i < count) {
                        int width;
                        int x;
                        if (i == 0) {
                            x = r1.x;
                            width = b.width - b.x;
                        } else if (i == count - 1) {
                            x = b.x;
                            width = r2.x - x;
                        } else {
                            x = b.x;
                            width = b.width - b.x;
                        }
                        g.fillRect(x, y, width, r1.height);
                        ++i;
                        y += r1.height;
                    }
                }
            } else {
                int height = r2.y - r1.y;
                if (height == 0) {
                    height = r1.height;
                }
                g.fillRect(0, r1.y, b.x + b.width, height);
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
    }

    private boolean isSearch() {
        return this == SEARCH || this == CURRENT_SEARCH;
    }

    @Override
    public void configurationChanged() {
        this.initConfiguration();
    }

    private void initConfiguration() {
        if (this.isAdd()) {
            this.color = this.getSettings().getAddedColor();
        } else if (this.isDeleted()) {
            this.color = this.getSettings().getDeletedColor();
        } else if (this.isChange()) {
            this.color = this.getSettings().getChangedColor();
        } else if (this.isChangeLighter()) {
            this.color = Colors.getChangedLighterColor(this.getSettings().getChangedColor());
        }
    }

    private boolean isChangeLighter() {
        return this == CHANGED_LIGHTER;
    }

    private boolean isChange() {
        return this == CHANGED;
    }

    private boolean isDeleted() {
        return this == DELETED || this == DELETED_LINE || this == DELETED_NEWLINE;
    }

    private boolean isAdd() {
        return this == ADDED || this == ADDED_LINE || this == ADDED_NEWLINE;
    }

    private EditorSettings getSettings() {
        return JMeldSettings.getInstance().getEditor();
    }

    static {
        ADDED.initConfiguration();
        ADDED_LINE = new JMHighlightLinePainter(Colors.ADDED);
        ADDED_LINE.initConfiguration();
        ADDED_NEWLINE = new JMHighlightNewLinePainter(Colors.ADDED);
        ADDED_NEWLINE.initConfiguration();
        CHANGED = new JMHighlightPainter(Colors.CHANGED);
        CHANGED.initConfiguration();
        CHANGED_NEWLINE = new JMHighlightNewLinePainter(Colors.CHANGED);
        CHANGED_NEWLINE.initConfiguration();
        CHANGED_LIGHTER = new JMHighlightPainter(Colors.CHANGED_LIGHTER);
        CHANGED_LIGHTER.initConfiguration();
        DELETED = new JMHighlightPainter(Colors.DELETED);
        DELETED.initConfiguration();
        DELETED_LINE = new JMHighlightLinePainter(Colors.DELETED);
        DELETED_LINE.initConfiguration();
        DELETED_NEWLINE = new JMHighlightNewLinePainter(Colors.DELETED);
        DELETED_NEWLINE.initConfiguration();
        SEARCH = new JMHighlightPainter(Color.yellow);
        SEARCH.initConfiguration();
        CURRENT_SEARCH = new JMHighlightPainter(Color.yellow.darker());
        CURRENT_SEARCH.initConfiguration();
    }
}

