/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.jmeld.ui.swing.LineNumberBorder;

public class JMHighlighter
implements Highlighter {
    public static final Integer LAYER0 = 1;
    public static final Integer LAYER1 = 2;
    public static final Integer LAYER2 = 3;
    public static final Integer LAYER3 = 4;
    public static final Integer UPPER_LAYER;
    private static ArrayList<Integer> layers;
    private Map<Integer, List<Highlighter.Highlight>> highlights = new HashMap<Integer, List<Highlighter.Highlight>>();
    private JTextComponent component;
    private boolean doNotRepaint;

    public void setDoNotRepaint(boolean doNotRepaint) {
        this.doNotRepaint = doNotRepaint;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        int lineHeight = this.component.getFontMetrics(this.component.getFont()).getHeight();
        int startOffset = this.component.viewToModel(new Point(clip.x - lineHeight, clip.y));
        int endOffset = this.component.viewToModel(new Point(clip.x, clip.y + clip.height + lineHeight));
        LineNumberBorder lineNumberBorder = null;
        if (this.component.getBorder() instanceof LineNumberBorder) {
            lineNumberBorder = (LineNumberBorder)this.component.getBorder();
        }
        if (lineNumberBorder != null) {
            lineNumberBorder.paintBefore(g);
        }
        Rectangle a = null;
        for (Integer layer : layers) {
            List<Highlighter.Highlight> list = this.highlights.get(layer);
            if (list == null || list.size() == 0) continue;
            if (a == null) {
                a = this.component.getBounds();
                Insets insets = this.component.getInsets();
                a.x = insets.left;
                a.y = insets.top;
                a.width -= insets.left + insets.right;
                a.height -= insets.top + insets.bottom;
            }
            for (Highlighter.Highlight hli : list) {
                if (hli.getStartOffset() > endOffset || hli.getEndOffset() < startOffset) continue;
                hli.getPainter().paint(g, hli.getStartOffset(), hli.getEndOffset(), a, this.component);
            }
        }
        if (lineNumberBorder != null) {
            lineNumberBorder.paintAfter(g, startOffset, endOffset);
        }
    }

    @Override
    public void install(JTextComponent c) {
        this.component = c;
        this.removeAllHighlights();
    }

    @Override
    public void deinstall(JTextComponent c) {
        this.component = null;
    }

    @Override
    public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter painter) throws BadLocationException {
        return this.addHighlight(UPPER_LAYER, p0, p1, painter);
    }

    public Object addHighlight(Integer layer, int p0, int p1, Highlighter.HighlightPainter painter) throws BadLocationException {
        Document doc = this.component.getDocument();
        HighlightInfo hli = new HighlightInfo();
        hli.p0 = doc.createPosition(p0);
        hli.p1 = doc.createPosition(p1);
        hli.painter = painter;
        this.getLayer(layer).add(hli);
        this.repaint();
        return hli;
    }

    @Override
    public void removeHighlight(Object object) {
        this.removeHighlight(UPPER_LAYER, object);
    }

    public void removeHighlight(Integer layer, Object object) {
        this.getLayer(layer).remove(object);
        this.repaint();
    }

    public void removeHighlights(Integer layer) {
        this.getLayer(layer).clear();
        this.repaint();
    }

    @Override
    public void removeAllHighlights() {
        for (Integer layer : layers) {
            this.getLayer(layer).clear();
        }
        this.repaint();
    }

    @Override
    public void changeHighlight(Object object, int p0, int p1) throws BadLocationException {
        this.changeHighlight(UPPER_LAYER, object, p0, p1);
    }

    public void changeHighlight(Integer layer, Object object, int p0, int p1) throws BadLocationException {
        Document doc = this.component.getDocument();
        HighlightInfo hli = (HighlightInfo)object;
        hli.p0 = doc.createPosition(p0);
        hli.p1 = doc.createPosition(p1);
        this.repaint();
    }

    @Override
    public Highlighter.Highlight[] getHighlights() {
        int size = 0;
        for (Integer layer : layers) {
            size += this.getLayer(layer).size();
        }
        Highlighter.Highlight[] result = new Highlighter.Highlight[size];
        int index = 0;
        for (Integer layer : layers) {
            Iterator<Highlighter.Highlight> iterator = this.getLayer(layer).iterator();
            while (iterator.hasNext()) {
                Highlighter.Highlight hli;
                result[index] = hli = iterator.next();
                ++index;
            }
        }
        return result;
    }

    private List<Highlighter.Highlight> getLayer(Integer layer) {
        List<Highlighter.Highlight> result = this.highlights.get(layer);
        if (result == null) {
            result = new ArrayList<Highlighter.Highlight>();
            this.highlights.put(layer, result);
        }
        return result;
    }

    public void repaint() {
        if (this.doNotRepaint) {
            return;
        }
        this.component.repaint();
    }

    static {
        layers = new ArrayList();
        layers.add(LAYER0);
        layers.add(LAYER1);
        layers.add(LAYER2);
        layers.add(LAYER3);
        UPPER_LAYER = layers.get(layers.size() - 1);
    }

    class HighlightInfo
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        HighlightInfo() {
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }
}

