/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing.table;

import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jmeld.ui.swing.table.JMTableModel;

public class JMTable
extends JTable {
    private int charWidth = this.getFontMetrics(this.getFont()).charWidth('W');

    public void setModel(JMTableModel tableModel) {
        super.setModel(tableModel);
        if (tableModel != null) {
            if (this.getRowHeight() < 22) {
                this.setRowHeight(22);
            }
            TableColumnModel columnModel = this.getColumnModel();
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                TableColumn column = columnModel.getColumn(i);
                TableCellRenderer renderer = tableModel.getRenderer(i);
                if (renderer != null) {
                    column.setCellRenderer(renderer);
                }
                TableCellEditor editor = tableModel.getEditor(i);
                if (renderer == null) continue;
                column.setCellEditor(editor);
            }
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Class clazz = ((JMTableModel)this.getModel()).getColumnClass(row, column);
        TableCellEditor editor = this.getDefaultEditor(clazz);
        if (editor != null) {
            return editor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Class clazz;
        TableCellRenderer renderer;
        TableModel model = this.getModel();
        if (model instanceof JMTableModel && (renderer = this.getDefaultRenderer(clazz = ((JMTableModel)model).getColumnClass(row, column))) != null) {
            return renderer;
        }
        return super.getCellRenderer(row, column);
    }
}

