/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class JMTableModel
extends AbstractTableModel {
    private List<Column> columns = new ArrayList<Column>();

    public Column addColumn(String id, String columnGroupName, String columnName, Class columnClass, int columnSize, boolean editable) {
        Column column = new Column(id, this.columns.size(), columnGroupName, columnName, columnClass, columnSize, editable);
        this.columns.add(column);
        return column;
    }

    @Override
    public abstract int getRowCount();

    public abstract Object getValueAt(int var1, Column var2);

    public void setValueAt(Object value, int rowIndex, Column column) {
    }

    public int getColumnSize(int columnIndex) {
        return this.getColumn((int)columnIndex).columnSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumn((int)columnIndex).columnName;
    }

    public Class getColumnClass(int columnIndex) {
        return this.getColumn((int)columnIndex).columnClass;
    }

    public Class getColumnClass(int rowIndex, Column column) {
        return null;
    }

    public Class getColumnClass(int rowIndex, int columnIndex) {
        return this.getColumnClass(rowIndex, this.getColumn(columnIndex));
    }

    public String getColumnGroupName(int columnIndex) {
        return this.getColumn((int)columnIndex).columnGroupName;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnId(int columnIndex) {
        return this.getColumn((int)columnIndex).id;
    }

    public TableCellRenderer getRenderer(int columnIndex) {
        return this.getColumn((int)columnIndex).renderer;
    }

    public TableCellEditor getEditor(int columnIndex) {
        return this.getColumn((int)columnIndex).editor;
    }

    public Column getColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, Column column) {
        return column.isEditable();
    }

    @Override
    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.checkRowCount(rowIndex)) {
            return false;
        }
        return this.isCellEditable(rowIndex, this.getColumn(columnIndex));
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (!this.checkRowCount(rowIndex)) {
            return "";
        }
        return this.getValueAt(rowIndex, this.getColumn(columnIndex));
    }

    @Override
    public final void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (!this.checkRowCount(rowIndex)) {
            return;
        }
        this.setValueAt(value, rowIndex, this.getColumn(columnIndex));
    }

    private boolean checkRowCount(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.getRowCount();
    }

    public class Column {
        private String id;
        private int columnIndex;
        private String columnGroupName;
        private String columnName;
        private Class columnClass;
        private int columnSize;
        private boolean editable;
        private TableCellRenderer renderer;
        private TableCellEditor editor;

        public Column(String id, int columnIndex, String columnGroupName, String columnName, Class columnClass, int columnSize, boolean editable) {
            this.id = id;
            this.columnIndex = columnIndex;
            this.columnGroupName = columnGroupName;
            this.columnName = columnName;
            this.columnClass = columnClass;
            this.columnSize = columnSize;
            this.editable = editable;
        }

        public String getId() {
            return this.id;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public String getColumnGroupName() {
            return this.columnGroupName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String toString() {
            return "column[id=" + this.id + "]";
        }

        public void setRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        public void setEditor(TableCellEditor editor) {
            this.editor = editor;
        }
    }
}

