/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jmeld.ui.UINode;

public abstract class JMTreeTableModel
extends DefaultTreeTableModel {
    private List<Column> columns = new ArrayList<Column>();

    public Object getChild(Object parent, int index) {
        return ((UINode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((UINode)parent).getChildCount();
    }

    public Column addColumn(String id, String columnGroupName, String columnName, Class columnClass, int columnSize, boolean editable) {
        Column column = new Column(id, this.columns.size(), columnGroupName, columnName, columnClass, columnSize, editable);
        this.columns.add(column);
        return column;
    }

    public abstract Object getValueAt(Object var1, Column var2);

    public int getColumnSize(int columnIndex) {
        return this.getColumn((int)columnIndex).columnSize;
    }

    public String getColumnName(int columnIndex) {
        return this.getColumn((int)columnIndex).columnName;
    }

    public Class getColumnClass(int columnIndex) {
        Class clazz = this.getColumn((int)columnIndex).columnClass;
        if (clazz != null) {
            return clazz;
        }
        return super.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnId(int columnIndex) {
        return this.getColumn((int)columnIndex).id;
    }

    public TableCellRenderer getRenderer(int columnIndex) {
        return this.getColumn((int)columnIndex).renderer;
    }

    public TableCellEditor getEditor(int columnIndex) {
        return this.getColumn((int)columnIndex).editor;
    }

    public Column getColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, Column column) {
        return column.isEditable();
    }

    public final boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isCellEditable(rowIndex, this.getColumn(columnIndex));
    }

    public final Object getValueAt(Object objectNode, int columnIndex) {
        return this.getValueAt(objectNode, this.getColumn(columnIndex));
    }

    public class Column {
        private String id;
        private int columnIndex;
        private String columnGroupName;
        private String columnName;
        private Class columnClass;
        private int columnSize;
        private boolean editable;
        private TableCellRenderer renderer;
        private TableCellEditor editor;

        public Column(String id, int columnIndex, String columnGroupName, String columnName, Class columnClass, int columnSize, boolean editable) {
            this.id = id;
            this.columnIndex = columnIndex;
            this.columnGroupName = columnGroupName;
            this.columnName = columnName;
            this.columnClass = columnClass;
            this.columnSize = columnSize;
            this.editable = editable;
        }

        public String getId() {
            return this.id;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public String getColumnGroupName() {
            return this.columnGroupName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class getColumnClass() {
            return this.columnClass;
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public String toString() {
            return "column[id=" + this.id + "]";
        }

        public void setRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        public void setEditor(TableCellEditor editor) {
            this.editor = editor;
        }
    }
}

