/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.text;

import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import org.jmeld.JMeldException;
import org.jmeld.ui.text.BufferDocumentChangeListenerIF;
import org.jmeld.ui.text.BufferDocumentIF;
import org.jmeld.ui.text.JMDocumentEvent;
import org.jmeld.util.StopWatch;
import org.jmeld.util.StringUtil;
import org.jmeld.vc.BlameIF;

public abstract class AbstractBufferDocument
implements BufferDocumentIF,
DocumentListener {
    private String name;
    private String shortName;
    private Line[] lineArray;
    private int[] lineOffsetArray;
    private PlainDocument document;
    private MyGapContent content;
    private List<BufferDocumentChangeListenerIF> listeners = new ArrayList<BufferDocumentChangeListenerIF>();
    private boolean changed;
    private int originalLength;
    private int digest;

    @Override
    public void addChangeListener(BufferDocumentChangeListenerIF listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(BufferDocumentChangeListenerIF listener) {
        this.listeners.remove(listener);
    }

    abstract int getBufferSize();

    @Override
    public abstract Reader getReader() throws JMeldException;

    abstract Writer getWriter() throws JMeldException;

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public PlainDocument getDocument() {
        return this.document;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public Line[] getLines() {
        this.initLines();
        return this.lineArray;
    }

    @Override
    public String getLineText(int lineNumber) {
        Line[] la = this.getLines();
        if (la == null) {
            return null;
        }
        if (lineNumber >= la.length || lineNumber < 0) {
            return "<NO LINE>";
        }
        return la[lineNumber].toString();
    }

    @Override
    public int getNumberOfLines() {
        return this.getLines().length;
    }

    @Override
    public int getOffsetForLine(int lineNumber) {
        if (lineNumber < 0) {
            return -1;
        }
        if (lineNumber == 0) {
            return 0;
        }
        Line[] la = this.getLines();
        if (la == null) {
            return -1;
        }
        if (lineNumber > la.length) {
            lineNumber = la.length;
        }
        return la[lineNumber - 1].getOffset();
    }

    @Override
    public int getLineForOffset(int offset) {
        if (offset < 0) {
            return 0;
        }
        Line[] la = this.getLines();
        if (la == null) {
            return 0;
        }
        if (offset >= this.lineOffsetArray[this.lineOffsetArray.length - 1]) {
            return this.lineOffsetArray.length - 1;
        }
        int searchIndex = Arrays.binarySearch(this.lineOffsetArray, offset);
        if (searchIndex >= 0) {
            return searchIndex + 1;
        }
        return -searchIndex - 1;
    }

    @Override
    public void read() throws JMeldException {
        try {
            if (this.document != null) {
                this.document.removeDocumentListener(this);
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            System.out.println("before read : " + this);
            this.content = new MyGapContent(this.getBufferSize() + 500);
            this.document = new PlainDocument(this.content);
            Reader reader = this.getReader();
            new DefaultEditorKit().read(reader, (Document)this.document, 0);
            reader.close();
            System.out.println("create document took " + stopWatch.getElapsedTime());
            this.document.addDocumentListener(this);
            this.reset();
            this.initLines();
            this.initDigest();
        }
        catch (JMeldException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JMeldException("Problem reading document (name=" + this.getName() + ") in buffer", ex);
        }
    }

    private void initLines() {
        if (this.lineArray != null) {
            return;
        }
        Element paragraph = this.document.getDefaultRootElement();
        int size = paragraph.getElementCount();
        this.lineArray = new Line[size];
        this.lineOffsetArray = new int[this.lineArray.length];
        for (int i = 0; i < this.lineArray.length; ++i) {
            Line line;
            Element e = paragraph.getElement(i);
            this.lineArray[i] = line = new Line(e);
            this.lineOffsetArray[i] = line.getOffset();
        }
    }

    public void reset() {
        this.lineArray = null;
        this.lineOffsetArray = null;
    }

    @Override
    public void write() throws JMeldException {
        System.out.println("write : " + this.getName());
        try {
            Writer out = this.getWriter();
            new DefaultEditorKit().write(out, (Document)this.document, 0, this.document.getLength());
            out.flush();
            out.close();
            this.initDigest();
        }
        catch (JMeldException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JMeldException("Problem writing document (name=" + this.getName() + ") from buffer", ex);
        }
    }

    @Override
    public void print() {
        Line[] la = this.getLines();
        if (la != null) {
            for (int lineNumber = 0; lineNumber < la.length; ++lineNumber) {
                System.out.printf("[%05d]", lineNumber);
                la[lineNumber].print();
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.documentChanged(de);
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.documentChanged(de);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.documentChanged(de);
    }

    private void initDigest() {
        this.originalLength = this.document != null ? this.document.getLength() : 0;
        this.digest = this.createDigest();
        this.changed = false;
        this.fireDocumentChanged(new JMDocumentEvent(this));
    }

    public int createDigest() {
        return this.content.getDigest();
    }

    private void documentChanged(DocumentEvent de) {
        JMDocumentEvent jmde = new JMDocumentEvent(this, de);
        int numberOfLinesChanged = 0;
        if (this.lineArray != null) {
            if (de.getType() == DocumentEvent.EventType.INSERT) {
                try {
                    String text = this.document.getText(de.getOffset(), de.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            numberOfLinesChanged = this.getLines().length;
            this.reset();
            numberOfLinesChanged = this.getLines().length - numberOfLinesChanged;
            int startLine = this.getLineForOffset(de.getOffset() + 1);
            if (startLine < 0) {
                System.out.println("haha");
            }
            jmde.setStartLine(startLine);
            jmde.setNumberOfLines(numberOfLinesChanged);
        }
        boolean newChanged = false;
        if (this.document.getLength() != this.originalLength) {
            newChanged = true;
        } else {
            int newDigest = this.createDigest();
            if (newDigest != this.digest) {
                newChanged = true;
            }
        }
        if (newChanged != this.changed) {
            this.changed = newChanged;
        }
        this.fireDocumentChanged(jmde);
    }

    private void fireDocumentChanged(JMDocumentEvent de) {
        for (BufferDocumentChangeListenerIF listener : this.listeners) {
            listener.documentChanged(de);
        }
    }

    @Override
    public BlameIF getVersionControlBlame() {
        return null;
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    public String toString() {
        return "Document[name=" + this.name + "]";
    }

    public class Line
    implements Comparable {
        Element element;

        Line(Element element) {
            this.element = element;
        }

        MyGapContent getContent() {
            return AbstractBufferDocument.this.content;
        }

        public int getOffset() {
            return this.element.getEndOffset();
        }

        public void print() {
            System.out.printf("[%08d]: %s\n", this.getOffset(), StringUtil.replaceNewLines(this.toString()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Line)) {
                return false;
            }
            Line line2 = (Line)o;
            Element element2 = line2.element;
            int start1 = this.element.getStartOffset();
            int end1 = this.element.getEndOffset();
            int start2 = element2.getStartOffset();
            int end2 = element2.getEndOffset();
            if (end1 - start1 != end2 - start2) {
                return false;
            }
            return AbstractBufferDocument.this.content.equals(line2.getContent(), start1, end1, start2);
        }

        public int hashCode() {
            return AbstractBufferDocument.this.content.hashCode(this.element.getStartOffset(), this.element.getEndOffset());
        }

        public String toString() {
            try {
                return AbstractBufferDocument.this.content.getString(this.element.getStartOffset(), this.element.getEndOffset() - this.element.getStartOffset());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "";
            }
        }

        public int compareTo(Object line) {
            return this.toString().compareTo(((Line)line).toString());
        }
    }

    class MyGapContent
    extends GapContent {
        public MyGapContent(int length) {
            super(length);
        }

        char[] getCharArray() {
            return (char[])this.getArray();
        }

        public char getChar(int offset) {
            int g0 = this.getGapStart();
            int g1 = this.getGapEnd();
            if (offset >= g0) {
                offset = g1 + offset - g0;
            }
            return this.getCharArray()[offset];
        }

        public boolean equals(MyGapContent c2, int start1, int end1, int start2) {
            char[] array1 = this.getCharArray();
            char[] array2 = c2.getCharArray();
            int g1_0 = this.getGapStart();
            int g1_1 = this.getGapEnd();
            int g2_0 = c2.getGapStart();
            int g2_1 = c2.getGapEnd();
            int o1 = start1 >= g1_0 ? start1 + g1_1 - g1_0 : start1;
            int o2 = start2 >= g2_0 ? start2 + g2_1 - g2_0 : start2;
            int size = end1 - start1;
            int i = 0;
            while (i < size) {
                if (o1 == g1_0) {
                    o1 += g1_1 - g1_0;
                }
                if (o2 == g2_0) {
                    o2 += g2_1 - g2_0;
                }
                if (array1[o1] != array2[o2]) {
                    return false;
                }
                ++i;
                ++o1;
                ++o2;
            }
            return true;
        }

        public int hashCode(int start, int end) {
            int h = 0;
            char[] array = this.getCharArray();
            int g0 = this.getGapStart();
            int g1 = this.getGapEnd();
            int o = start >= g0 ? start + g1 - g0 : start;
            int size = end - start;
            int i = 0;
            while (i < size) {
                if (o == g0) {
                    o += g1 - g0;
                }
                h = 31 * h + array[o];
                ++i;
                ++o;
            }
            if (h == 0) {
                h = 1;
            }
            return h;
        }

        public int getDigest() {
            return this.hashCode(0, AbstractBufferDocument.this.document.getLength());
        }
    }
}

