/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.text;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jmeld.JMeldException;
import org.jmeld.ui.text.AbstractBufferDocument;
import org.jmeld.util.CharsetDetector;
import org.jmeld.util.node.FileNode;
import org.jmeld.vc.BaseFile;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.VersionControlIF;

public class VersionControlBaseDocument
extends AbstractBufferDocument {
    private VersionControlIF versionControl;
    private StatusResult.Entry entry;
    private FileNode fileNode;
    private File file;
    private BaseFile baseFile;
    private boolean baseFileInitialized;

    public VersionControlBaseDocument(VersionControlIF versionControl, StatusResult.Entry entry, FileNode fileNode, File file) {
        this.versionControl = versionControl;
        this.entry = entry;
        this.fileNode = fileNode;
        this.file = file;
        try {
            this.setName(file.getCanonicalPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setName(file.getName());
        }
        this.setShortName(file.getName());
    }

    public boolean isBaseFileInitialized() {
        return this.baseFileInitialized;
    }

    public void setBaseFileInitialized(boolean baseFileInitialized) {
        this.baseFileInitialized = baseFileInitialized;
    }

    @Override
    public int getBufferSize() {
        if (this.useBaseFile()) {
            BaseFile baseFile = this.getBaseFile();
            return baseFile == null ? -1 : baseFile.getLength();
        }
        return this.fileNode.getDocument().getBufferSize();
    }

    @Override
    public Reader getReader() throws JMeldException {
        if (this.useBaseFile()) {
            try {
                BaseFile baseFile = this.getBaseFile();
                BufferedInputStream bais = new BufferedInputStream(new ByteArrayInputStream(baseFile.getByteArray()));
                Charset charset = CharsetDetector.getInstance().getCharset(bais);
                return new BufferedReader(new InputStreamReader((InputStream)bais, charset));
            }
            catch (Exception ex) {
                throw new JMeldException("Could not create FileReader for : " + this.file.getName(), ex);
            }
        }
        if (this.entry.getStatus() == StatusResult.Status.unversioned || this.entry.getStatus() == StatusResult.Status.added) {
            return new StringReader("");
        }
        return this.fileNode.getDocument().getReader();
    }

    @Override
    protected Writer getWriter() throws JMeldException {
        return null;
    }

    private boolean useBaseFile() {
        switch (this.entry.getStatus()) {
            case modified: 
            case removed: 
            case missing: 
            case index_modified: 
            case index_removed: {
                return true;
            }
        }
        return false;
    }

    private BaseFile getBaseFile() {
        this.baseFile = this.versionControl.getBaseFile(this.file);
        this.setBaseFileInitialized(true);
        return this.baseFile;
    }

    @Override
    public boolean isReadonly() {
        return true;
    }
}

