/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.tree;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jmeld.JMeldException;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMDiff;
import org.jmeld.diff.JMRevision;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.tree.DiffTreeCellRenderer;
import org.jmeld.ui.tree.JMChange;
import org.jmeld.ui.tree.JMChunkNode;
import org.jmeld.ui.tree.JMDeltaNode;
import org.jmeld.util.Ignore;
import org.jmeld.vc.util.VcCmd;

public class DiffTree
extends JTree {
    public DiffTree() {
        this(new DefaultTreeModel(new DefaultMutableTreeNode(null)));
    }

    public DiffTree(JMRevision revision) {
        this(DiffTree.buildTreemodel(revision));
    }

    public DiffTree(DefaultTreeModel model) {
        super(model);
        this.setCellRenderer(new DiffTreeCellRenderer());
    }

    private static DefaultTreeModel buildTreemodel(JMRevision revision) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(revision);
        if (JMeldSettings.getInstance().getEditor().isShowTreeRaw()) {
            DiffTree.addRawNodes(revision, root);
        } else {
            DiffTree.addNodes(revision, root);
        }
        return new DefaultTreeModel(root);
    }

    private static void addNodes(JMRevision revision, DefaultMutableTreeNode root) {
        if (revision != null) {
            for (JMDelta delta : revision.getDeltas()) {
                int initLine = delta.getOriginal().getAnchor();
                int numLines = delta.getRevised().getSize();
                JMRevision changeRevision = delta.getChangeRevision();
                for (JMDelta changeDelta : changeRevision.getDeltas()) {
                    JMChunk orgChunk = changeDelta.getOriginal();
                    JMChunk revChunk = changeDelta.getRevised();
                    int startCol = orgChunk.getAnchor();
                    int endCol = revChunk.getAnchor();
                    int modifiedchars = revChunk.getSize() - orgChunk.getSize();
                    JMChunkNode orgNode = new JMChunkNode(orgChunk, changeRevision.getOriginalString(orgChunk));
                    JMChunkNode revNode = new JMChunkNode(revChunk, changeRevision.getRevisedString(revChunk));
                    DefaultMutableTreeNode childDelta = new DefaultMutableTreeNode(changeDelta);
                    childDelta.add(orgNode);
                    childDelta.add(revNode);
                    JMChange change = new JMChange(initLine, numLines, startCol, endCol, modifiedchars);
                    DefaultMutableTreeNode changeNode = new DefaultMutableTreeNode(change);
                    changeNode.add(childDelta);
                    root.add(changeNode);
                }
            }
        }
    }

    private static void addRawNodes(JMRevision revision, DefaultMutableTreeNode parent) {
        if (revision != null) {
            for (JMDelta delta : revision.getDeltas()) {
                DefaultMutableTreeNode deltaNode = DiffTree.buildDeltaNode(delta, revision);
                JMRevision changeRevision = delta.getChangeRevision();
                for (JMDelta changeDelta : changeRevision.getDeltas()) {
                    DefaultMutableTreeNode changeDeltaNode = DiffTree.buildDeltaNode(changeDelta, changeRevision);
                    deltaNode.add(changeDeltaNode);
                }
                parent.add(deltaNode);
            }
        }
    }

    private static DefaultMutableTreeNode buildDeltaNode(JMDelta delta, JMRevision revision) {
        JMChunk orgChunk = delta.getOriginal();
        JMChunk revChunk = delta.getRevised();
        JMDeltaNode deltaNode = new JMDeltaNode(delta);
        deltaNode.add(new JMChunkNode(orgChunk, revision.getOriginalString(orgChunk)));
        deltaNode.add(new JMChunkNode(revChunk, revision.getRevisedString(revChunk)));
        return deltaNode;
    }

    public void setRevision(JMRevision revision) {
        this.setModel(DiffTree.buildTreemodel(revision));
    }

    public static void main(String[] args) throws IOException, JMeldException {
        String line;
        File file = VcCmd.parseFile(args, 0);
        if (file == null) {
            return;
        }
        File file2 = VcCmd.parseFile(args, 1);
        if (file2 == null) {
            return;
        }
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(new Dimension(400, 300));
        BufferedReader readerOrg = new BufferedReader(new FileReader(file));
        Vector<String> vOrg = new Vector<String>();
        while ((line = readerOrg.readLine()) != null) {
            vOrg.add(line);
        }
        BufferedReader readerRev = new BufferedReader(new FileReader(file2));
        Vector<String> vRev = new Vector<String>();
        while ((line = readerRev.readLine()) != null) {
            vRev.add(line);
        }
        JMRevision revision = new JMDiff().diff(vOrg.toArray(), vRev.toArray(), Ignore.NULL_IGNORE);
        DiffTree tree = new DiffTree(DiffTree.buildTreemodel(revision));
        frame.add(new JScrollPane(tree));
        frame.pack();
        frame.setVisible(true);
    }
}

