/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jmeld.diff.JMChunk;
import org.jmeld.diff.JMDelta;
import org.jmeld.diff.JMRevision;
import org.jmeld.diff.TypeDiff;
import org.jmeld.ui.tree.JMChange;
import org.jmeld.ui.tree.JMChunkNode;
import org.jmeld.ui.tree.TreeColorIcon;
import org.jmeld.ui.util.RevisionUtil;

class DiffTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color COLOR_CHUNK = new Color(217, 154, 13);
    private static final Color COLOR_CHANGE = new Color(237, 38, 139);
    private static final Color COLOR_DELTA = new Color(209, 70, 237);
    private static final Color COLOR_REVISION = new Color(39, 86, 189);

    DiffTreeCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof JMRevision) {
            this.setIcon(new TreeColorIcon(COLOR_REVISION));
            JMRevision revision = (JMRevision)userObject;
            int numChanges = revision.getDeltas().size();
            this.setText(String.format("%d changes, %s", numChanges, revision.getIgnore()));
        } else if (userObject instanceof JMChange) {
            JMChange JMChange2 = (JMChange)userObject;
            this.setIcon(new TreeColorIcon(COLOR_CHANGE));
            this.setText(JMChange2.toString());
        } else if (userObject instanceof JMDelta) {
            JMDelta delta = (JMDelta)userObject;
            this.setIcon(new TreeColorIcon(RevisionUtil.getColor(delta)));
            TypeDiff type = delta.getType();
            this.setText(type.toString());
        } else if (value instanceof JMChunkNode) {
            this.setIcon(new TreeColorIcon(COLOR_CHUNK));
            JMChunkNode chunkNode = (JMChunkNode)value;
            JMChunk chunk = chunkNode.getChunk();
            this.setText(String.format("%d, %d: \"%s\"", chunk.getAnchor(), chunk.getSize(), chunkNode.getString()));
        }
        return this;
    }
}

