/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

class BrightnessFilter
extends RGBImageFilter {
    float percent;

    public BrightnessFilter(float percent) {
        this.canFilterIndexColorModel = true;
        this.percent = percent;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int b = rgb & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int a = rgb >> 24 & 0xFF;
        if (a == 255) {
            float[] hsb = Color.RGBtoHSB(r, g, b, null);
            hsb[2] = hsb[2] + this.percent;
            if ((double)hsb[2] > 1.0) {
                hsb[2] = 1.0f;
            }
            if ((double)hsb[2] < 0.0) {
                hsb[2] = 0.0f;
            }
            rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            rgb |= (a & 0xFF) << 24;
        }
        return rgb;
    }
}

