/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.util;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.jmeld.ui.util.BrightnessFilter;
import org.jmeld.ui.util.TransparentFilter;
import org.jmeld.util.ResourceLoader;

public class ImageUtil {
    public static synchronized ImageIcon getSmallImageIcon(String iconName) {
        return ImageUtil.getImageIcon("16x16/" + iconName + "-16");
    }

    public static synchronized ImageIcon getLargeImageIcon(String iconName) {
        return ImageUtil.getImageIcon("32x32/" + iconName);
    }

    public static synchronized ImageIcon getImageIcon(String iconName) {
        URL url = ResourceLoader.getResource((String)(iconName = "images/" + (String)iconName + ".png"));
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static ImageIcon createDarkerIcon(ImageIcon icon) {
        return ImageUtil.createDarkerIcon(icon, -0.1f);
    }

    public static ImageIcon createDarkerIcon(ImageIcon icon, float percentage) {
        return ImageUtil.createIcon(icon, new BrightnessFilter(percentage));
    }

    public static ImageIcon createTransparentIcon(ImageIcon icon) {
        return ImageUtil.createTransparentIcon(icon, 20);
    }

    public static ImageIcon createTransparentIcon(ImageIcon icon, int percentage) {
        return ImageUtil.createIcon(icon, new TransparentFilter(percentage));
    }

    private static synchronized ImageIcon createIcon(ImageIcon icon, ImageFilter filter) {
        if (icon == null) {
            return null;
        }
        FilteredImageSource ip = new FilteredImageSource(icon.getImage().getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(ip);
        MediaTracker tracker = new MediaTracker(new JPanel());
        tracker.addImage(image, 1);
        try {
            tracker.waitForID(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        return new ImageIcon(image);
    }
}

