/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util;

import org.jmeld.settings.JMeldSettings;
import org.jmeld.util.Tokenizer;
import org.jmeld.util.WordTokenizer;
import org.jmeld.util.conf.ConfigurationListenerIF;

public class TokenizerFactory
implements ConfigurationListenerIF {
    private static TokenizerFactory instance;
    private Tokenizer innerDiffTokenizer;
    private Tokenizer fileNameTokenizer;

    public static TokenizerFactory getInstance() {
        if (instance == null) {
            instance = new TokenizerFactory();
        }
        return instance;
    }

    private TokenizerFactory() {
        JMeldSettings.getInstance().addConfigurationListener(this);
    }

    public synchronized Tokenizer getInnerDiffTokenizer() {
        if (this.innerDiffTokenizer == null) {
            String tokenizerName = JMeldSettings.getInstance().getEditor().getTypeTokenizerName();
            WordTokenizer innerDiffTokenizer = "char".equals(tokenizerName) ? new WordTokenizer(".") : ("word".equals(tokenizerName) ? new WordTokenizer("\\b\\B*") : ("nonword".equals(tokenizerName) ? new WordTokenizer("\\s|;|:|\\(|\\)|\\[|\\]|[-+*&^%\\/}{=<>`'\"|]+|\\.") : null));
            this.setInnerDiffTokenizer(innerDiffTokenizer);
        }
        return this.innerDiffTokenizer;
    }

    public synchronized Tokenizer getFileNameTokenizer() {
        if (this.fileNameTokenizer == null) {
            this.setFileNameTokenizer(new WordTokenizer("[ /\\\\]+"));
        }
        return this.fileNameTokenizer;
    }

    private void setInnerDiffTokenizer(Tokenizer innerDiffTokenizer) {
        this.innerDiffTokenizer = innerDiffTokenizer;
    }

    private void setFileNameTokenizer(Tokenizer fileNameTokenizer) {
        this.fileNameTokenizer = fileNameTokenizer;
    }

    @Override
    public void configurationChanged() {
        this.setInnerDiffTokenizer(null);
        this.setFileNameTokenizer(null);
    }
}

