/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.conf;

import java.io.File;
import java.io.IOException;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.conf.ConfigurationManager;
import org.jmeld.util.conf.ConfigurationPersister;
import org.jmeld.util.conf.ConfigurationPreference;

public abstract class AbstractConfiguration {
    private boolean changed;
    private ConfigurationPreference preference = new ConfigurationPreference(this.getClass());
    private boolean disableFireChanged;
    private boolean drawCurves;
    private int curveType;

    public abstract void init();

    public String getConfigurationFileName() {
        try {
            return this.preference.getFile().getCanonicalPath();
        }
        catch (IOException ex) {
            return "??";
        }
    }

    public void setConfigurationFile(File file) {
        this.preference.setFile(file);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void save() {
        try {
            ConfigurationPersister.getInstance().save(this, this.preference.getFile());
            this.changed = false;
            this.fireChanged(this.changed);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addConfigurationListener(ConfigurationListenerIF listener) {
        this.getManager().addConfigurationListener(this.getClass(), listener);
    }

    public void removeConfigurationListener(ConfigurationListenerIF listener) {
        this.getManager().removeConfigurationListener(this.getClass(), listener);
    }

    void disableFireChanged(boolean disableFireChanged) {
        this.disableFireChanged = disableFireChanged;
    }

    public void fireChanged() {
        if (this.disableFireChanged) {
            return;
        }
        this.fireChanged(true);
    }

    public void fireChanged(boolean changed) {
        this.changed = changed;
        this.getManager().fireChanged(this.getClass());
    }

    private ConfigurationManager getManager() {
        return ConfigurationManager.getInstance();
    }

    public boolean getDrawCurves() {
        return this.drawCurves;
    }

    public boolean isDrawCurves() {
        return this.drawCurves;
    }

    public void setDrawCurves(boolean drawCurves) {
        this.drawCurves = drawCurves;
    }

    public int getCurveType() {
        return this.curveType;
    }

    public void setCurveType(int curveType) {
        this.curveType = curveType;
    }
}

