/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.conf;

import java.io.File;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jmeld.util.WeakHashSet;
import org.jmeld.util.conf.AbstractConfiguration;
import org.jmeld.util.conf.ConfigurationListenerIF;
import org.jmeld.util.conf.ConfigurationPersister;
import org.jmeld.util.conf.ConfigurationPreference;

public class ConfigurationManager {
    private static ConfigurationManager instance = new ConfigurationManager();
    private Map<String, AbstractConfiguration> configurations = new HashMap<String, AbstractConfiguration>();
    private Map<String, WeakHashSet<ConfigurationListenerIF>> listenerMap = new HashMap<String, WeakHashSet<ConfigurationListenerIF>>();

    private ConfigurationManager() {
    }

    public static ConfigurationManager getInstance() {
        return instance;
    }

    public boolean reload(File file, Class clazz) {
        AbstractConfiguration configuration = this.load(clazz, file);
        if (configuration == null) {
            return false;
        }
        configuration.setConfigurationFile(file);
        this.configurations.put(clazz.getName(), configuration);
        this.fireChanged(clazz);
        return true;
    }

    public AbstractConfiguration get(Class clazz) {
        String key = clazz.getName();
        AbstractConfiguration configuration = this.configurations.get(key);
        if (configuration == null) {
            configuration = this.load(clazz);
            if (configuration == null) {
                try {
                    configuration = (AbstractConfiguration)clazz.newInstance();
                    configuration.disableFireChanged(true);
                    configuration.init();
                    configuration.disableFireChanged(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.configurations.put(key, configuration);
        }
        return configuration;
    }

    private AbstractConfiguration load(Class clazz) {
        ConfigurationPreference preference = new ConfigurationPreference(clazz);
        File file = preference.getFile();
        return this.load(clazz, file);
    }

    private AbstractConfiguration load(Class clazz, File file) {
        if (file.exists()) {
            try {
                return ConfigurationPersister.getInstance().load(clazz, file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    void addConfigurationListener(Class clazz, ConfigurationListenerIF listener) {
        String key = clazz.getName();
        WeakHashSet<ConfigurationListenerIF> listeners = this.listenerMap.get(key);
        if (listeners == null) {
            listeners = new WeakHashSet();
            this.listenerMap.put(key, listeners);
        }
        listeners.add(listener);
    }

    void removeConfigurationListener(Class clazz, ConfigurationListenerIF listener) {
        Set listeners = this.listenerMap.get(clazz.getName());
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    void fireChanged(Class clazz) {
        Set listeners = this.listenerMap.get(clazz.getName());
        if (listeners != null) {
            try {
                WeakHashSet isolateListeners = new WeakHashSet(listeners);
                for (ConfigurationListenerIF listener : isolateListeners) {
                    listener.configurationChanged();
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
    }
}

