/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.conf;

import java.io.File;
import java.io.IOException;
import org.jmeld.util.prefs.Preference;

public class ConfigurationPreference
extends Preference {
    private static String FILENAME = "FILENAME";
    private Class clazz;
    private File file;

    public ConfigurationPreference(Class clazz) {
        super("Configuration-" + clazz);
        this.clazz = clazz;
        this.init();
    }

    private void init() {
        Object defaultFileName = this.clazz.getName();
        int index = ((String)defaultFileName).lastIndexOf(".");
        if (index != -1) {
            defaultFileName = ((String)defaultFileName).substring(index + 1);
        }
        try {
            defaultFileName = new File(System.getProperty("user.home"), (String)defaultFileName).getCanonicalPath();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        defaultFileName = (String)defaultFileName + ".xml";
        String fileName = this.getString(FILENAME, (String)defaultFileName);
        this.file = new File(fileName);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.save();
    }

    public void save() {
        try {
            this.putString(FILENAME, this.file.getCanonicalPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

