/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeld.tools.ant.DirectoryScanner;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.settings.util.Filter;
import org.jmeld.ui.StatusBar;
import org.jmeld.util.StopWatch;
import org.jmeld.util.StringUtil;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.node.FileNode;
import org.jmeld.util.node.JMDiffNode;
import org.jmeld.vc.util.VcCmd;

public class DirectoryDiff
extends FolderDiff {
    private File rightDirectory;
    private File leftDirectory;
    private JMDiffNode rootNode;
    private Map<String, JMDiffNode> nodes;
    private Filter filter;

    public DirectoryDiff(File leftDirectory, File rightDirectory, Filter filter, FolderDiff.Mode mode) {
        super(mode);
        this.leftDirectory = leftDirectory;
        this.rightDirectory = rightDirectory;
        this.filter = filter;
        try {
            this.setLeftFolderShortName(leftDirectory.getName());
            this.setRightFolderShortName(rightDirectory.getName());
            this.setLeftFolderName(leftDirectory.getCanonicalPath());
            this.setRightFolderName(rightDirectory.getCanonicalPath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public JMDiffNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public Collection<JMDiffNode> getNodes() {
        return this.nodes.values();
    }

    @Override
    public void diff() {
        JMDiffNode node;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        StatusBar.getInstance().start();
        StatusBar.getInstance().setState("Start scanning directories...", new Object[0]);
        this.rootNode = new JMDiffNode("<root>", false);
        this.nodes = new HashMap<String, JMDiffNode>();
        DirectoryScanner ds = new DirectoryScanner();
        ds.setShowStateOn(true);
        ds.setBasedir(this.leftDirectory);
        if (this.filter != null) {
            ds.setIncludes(this.filter.getIncludes());
            ds.setExcludes(this.filter.getExcludes());
        }
        ds.setCaseSensitive(true);
        ds.scan();
        for (FileNode fileNode : ds.getIncludedFilesMap().values()) {
            node = this.addNode(fileNode.getName());
            node.setBufferNodeLeft(fileNode);
        }
        ds = new DirectoryScanner();
        ds.setShowStateOn(true);
        ds.setBasedir(this.rightDirectory);
        if (this.filter != null) {
            ds.setIncludes(this.filter.getIncludes());
            ds.setExcludes(this.filter.getExcludes());
        }
        ds.setCaseSensitive(true);
        ds.scan();
        for (FileNode fileNode : ds.getIncludedFilesMap().values()) {
            node = this.addNode(fileNode.getName());
            node.setBufferNodeRight(fileNode);
        }
        StatusBar.getInstance().setState("Comparing nodes...", new Object[0]);
        int numberOfNodes = this.nodes.size();
        int currentNumber = 0;
        for (JMDiffNode n : this.nodes.values()) {
            if (n.getBufferNodeRight() == null || n.getBufferNodeLeft() == null) {
                FileNode fn;
                if (n.getBufferNodeRight() == null) {
                    fn = (FileNode)n.getBufferNodeLeft();
                    fn = new FileNode(fn.getName(), new File(this.rightDirectory, fn.getName()));
                    n.setBufferNodeRight(fn);
                } else {
                    fn = (FileNode)n.getBufferNodeRight();
                    fn = new FileNode(fn.getName(), new File(this.leftDirectory, fn.getName()));
                    n.setBufferNodeLeft(fn);
                }
            }
            n.compareContents();
            StatusBar.getInstance().setProgress(++currentNumber, numberOfNodes);
        }
        StatusBar.getInstance().setState("Ready comparing directories (took " + stopWatch.getElapsedTime() / 1000L + " seconds)", new Object[0]);
        StatusBar.getInstance().stop();
    }

    private JMDiffNode addNode(String name) {
        JMDiffNode node = this.nodes.get(name);
        if (node == null) {
            node = this.addNode(new JMDiffNode(name, true));
        }
        return node;
    }

    private JMDiffNode addNode(JMDiffNode node) {
        JMDiffNode parent;
        this.nodes.put(node.getName(), node);
        String parentName = node.getParentName();
        if (StringUtil.isEmpty(parentName)) {
            parent = this.rootNode;
        } else {
            parent = this.nodes.get(parentName);
            if (parent == null) {
                parent = this.addNode(new JMDiffNode(parentName, false));
                parent.setBufferNodeRight(new FileNode(parentName, new File(this.rightDirectory, parentName)));
                parent.setBufferNodeLeft(new FileNode(parentName, new File(this.leftDirectory, parentName)));
            }
        }
        parent.addChild(node);
        return node;
    }

    public void print() {
        this.rootNode.print("");
    }

    public static void main(String[] args) {
        File file = DirectoryDiff.parseDirectory(args, 0);
        if (file == null) {
            return;
        }
        File file2 = DirectoryDiff.parseDirectory(args, 1);
        if (file2 == null) {
            return;
        }
        DirectoryDiff diff = new DirectoryDiff(file, file2, JMeldSettings.getInstance().getFilter().getFilter("default"), FolderDiff.Mode.TWO_WAY);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        diff.diff();
        System.out.println("diff took " + stopWatch.getElapsedTime() + " msec.");
        diff.print();
    }

    private static File parseDirectory(String[] args, int pos) {
        File file = VcCmd.parseFile(args, pos);
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            System.err.println(file.getName() + " is not a directory");
            return null;
        }
        return file;
    }
}

