/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jmeld.ui.StatusBar;
import org.jmeld.util.StopWatch;
import org.jmeld.util.StringUtil;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.node.FileNode;
import org.jmeld.util.node.JMDiffNode;
import org.jmeld.util.node.VersionControlBaseNode;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.VersionControlIF;
import org.jmeld.vc.VersionControlUtil;
import org.jmeld.vc.util.VcCmd;

public class VersionControlDiff
extends FolderDiff {
    private File file;
    private JMDiffNode rootNode;
    private Map<String, JMDiffNode> nodes;
    private VersionControlIF versionControl;

    public VersionControlDiff(File file, FolderDiff.Mode mode) {
        super(mode);
        this.setFile(file);
        this.setVersionControl(VersionControlUtil.getFirstVersionControl(this.getFile()));
        try {
            this.setLeftFolderShortName(file.getName());
            this.setRightFolderShortName("");
            this.setLeftFolderName(file.getCanonicalPath());
            this.setRightFolderName("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public JMDiffNode getRootNode() {
        return this.rootNode;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public VersionControlIF getVersionControl() {
        return this.versionControl;
    }

    public void setVersionControl(VersionControlIF versionControl) {
        this.versionControl = versionControl;
    }

    @Override
    public Collection<JMDiffNode> getNodes() {
        return this.nodes.values();
    }

    @Override
    public void diff() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        StatusBar.getInstance().start();
        StatusBar.getInstance().setState("Start scanning directories...", new Object[0]);
        this.rootNode = new JMDiffNode("<root>", false);
        this.nodes = new HashMap<String, JMDiffNode>();
        StatusResult statusResult = this.getVersionControl().executeStatus(this.getFile());
        for (StatusResult.Entry entry : statusResult.getEntryList()) {
            File file = new File(statusResult.getPath(), entry.getName());
            JMDiffNode node = this.buildNode(entry.getName(), file.isFile());
            FileNode fileNode = new FileNode(entry.getName(), file);
            node.setBufferNodeLeft(new VersionControlBaseNode(this.getVersionControl(), entry, fileNode, file));
            node.setBufferNodeRight(fileNode);
            switch (entry.getStatus()) {
                case unmodified: {
                    node.setCompareState(JMDiffNode.Compare.Equal);
                    break;
                }
                case modified: 
                case index_modified: 
                case conflicted: 
                case missing: 
                case dontknow: {
                    node.setCompareState(JMDiffNode.Compare.NotEqual);
                    break;
                }
                case unversioned: 
                case added: 
                case index_added: {
                    node.setCompareState(JMDiffNode.Compare.LeftMissing);
                    break;
                }
                case removed: 
                case index_removed: {
                    node.setCompareState(JMDiffNode.Compare.RightMissing);
                    break;
                }
                case clean: 
                case ignored: {
                    node.setCompareState(JMDiffNode.Compare.Equal);
                }
            }
        }
        StatusBar.getInstance().setState("Ready comparing directories (took " + stopWatch.getElapsedTime() / 1000L + " seconds)", new Object[0]);
        StatusBar.getInstance().stop();
    }

    private JMDiffNode buildNode(String name, boolean leaf) {
        JMDiffNode node = this.nodes.get(name);
        if (node == null) {
            node = this.addNode(name, leaf);
        }
        return node;
    }

    private JMDiffNode addNode(String name, boolean leaf) {
        JMDiffNode node = new JMDiffNode(name, leaf);
        this.nodes.put(name, node);
        this.buildParentNode(node);
        return node;
    }

    private void buildParentNode(JMDiffNode node) {
        JMDiffNode parentnode;
        String parentName = node.getParentName();
        if (StringUtil.isEmpty(parentName)) {
            parentnode = this.rootNode;
        } else {
            parentnode = this.nodes.get(parentName);
            if (parentnode == null) {
                parentnode = this.addNode(parentName, false);
                FileNode fn = new FileNode(parentName, new File(this.file, parentName));
                parentnode.setBufferNodeRight(fn);
                parentnode.setBufferNodeLeft(fn);
            }
        }
        parentnode.addChild(node);
    }

    public void print() {
        this.rootNode.print("");
    }

    public static void main(String[] args) {
        File file = VcCmd.parseFile(args);
        if (file == null) {
            return;
        }
        VersionControlDiff diff = new VersionControlDiff(file, FolderDiff.Mode.TWO_WAY);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        diff.diff();
        System.err.println("diff took " + stopWatch.getElapsedTime() + " msec.");
        diff.print();
    }
}

