/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;

public abstract class AbstractCmd
extends AbstractUndoableEdit {
    private List<Command> commandList = new ArrayList<Command>();
    private List<Command> finallyCommandList = new ArrayList<Command>();
    protected boolean debug = true;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public synchronized void execute() throws Exception {
        this.commandList.clear();
        this.finallyCommandList.clear();
        this.createCommands();
        for (Command command : this.commandList) {
            command.execute();
        }
        for (Command command : this.finallyCommandList) {
            command.execute();
        }
    }

    protected abstract void createCommands() throws Exception;

    protected void addCommand(Command command) {
        this.commandList.add(command);
    }

    protected void addFinallyCommand(Command command) {
        this.finallyCommandList.add(command);
    }

    @Override
    public synchronized void redo() {
        super.redo();
        for (Command command : this.commandList) {
            command.redo();
        }
        for (Command command : this.finallyCommandList) {
            command.redo();
        }
    }

    @Override
    public synchronized void undo() {
        super.undo();
        try {
            Collections.reverse(this.commandList);
            for (Command command : this.commandList) {
                command.undo();
            }
            Collections.reverse(this.commandList);
            Collections.reverse(this.finallyCommandList);
            for (Command command : this.finallyCommandList) {
                command.undo();
            }
            Collections.reverse(this.finallyCommandList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CannotRedoException();
        }
    }

    public synchronized void discard() {
        Collections.reverse(this.commandList);
        for (Command command : this.commandList) {
            command.discard();
        }
        this.commandList.clear();
        Collections.reverse(this.finallyCommandList);
        for (Command command : this.finallyCommandList) {
            command.discard();
        }
        this.finallyCommandList.clear();
    }

    abstract class Command {
        Command() {
        }

        public abstract void execute() throws Exception;

        public void redo() {
            try {
                this.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CannotRedoException();
            }
        }

        public abstract void undo();

        public void discard() {
        }
    }
}

