/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.file.cmd;

import java.io.File;
import javax.swing.undo.CannotUndoException;
import org.jmeld.util.file.FileUtil;
import org.jmeld.util.file.cmd.AbstractCmd;
import org.jmeld.util.node.FileNode;
import org.jmeld.util.node.JMDiffNode;

public class RemoveFileCmd
extends AbstractCmd {
    private JMDiffNode diffNode;
    private FileNode fileNode;

    public RemoveFileCmd(JMDiffNode diffNode, FileNode fileNode) {
        this.diffNode = diffNode;
        this.fileNode = fileNode;
    }

    @Override
    public void createCommands() throws Exception {
        this.addCommand(new RemoveCommand(this.fileNode.getFile()));
        this.addFinallyCommand(new ResetCommand(this.fileNode));
    }

    class ResetCommand
    extends AbstractCmd.Command {
        private FileNode fileNode;

        ResetCommand(FileNode fileNode) {
            this.fileNode = fileNode;
        }

        @Override
        public void execute() throws Exception {
            this.reset();
        }

        @Override
        public void undo() {
            this.reset();
        }

        @Override
        public void discard() {
            this.reset();
        }

        private void reset() {
            this.fileNode.resetContent();
            RemoveFileCmd.this.diffNode.compareContents();
        }
    }

    class RemoveCommand
    extends AbstractCmd.Command {
        private File file;
        private File originalFile;

        RemoveCommand(File file) {
            this.file = file;
        }

        @Override
        public void execute() throws Exception {
            if (this.file.exists()) {
                this.originalFile = FileUtil.createTempFile("jmeld", "backup");
                if (RemoveFileCmd.this.debug) {
                    System.out.println("copy : " + this.file + " -> " + this.originalFile);
                }
                FileUtil.copy(this.file, this.originalFile);
            }
            if (RemoveFileCmd.this.debug) {
                System.out.println("delete : " + this.file);
            }
            this.file.delete();
        }

        @Override
        public void undo() {
            try {
                if (this.originalFile != null) {
                    if (RemoveFileCmd.this.debug) {
                        System.out.println("copy : " + this.originalFile + " -> " + this.file);
                    }
                    FileUtil.copy(this.originalFile, this.file);
                }
            }
            catch (Exception ex) {
                throw new CannotUndoException();
            }
        }

        @Override
        public void discard() {
            if (this.originalFile != null) {
                if (RemoveFileCmd.this.debug) {
                    System.out.println("delete : " + this.originalFile);
                }
                this.originalFile.delete();
            }
        }
    }
}

