/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.node;

import java.io.File;
import org.jmeld.ui.text.FileDocument;
import org.jmeld.util.node.BufferNode;
import org.jmeld.util.node.JMeldNode;

public class FileNode
extends JMeldNode
implements BufferNode {
    private File file;
    private long fileLastModified;
    private FileDocument document;
    private boolean exists;

    public FileNode(String name, File file) {
        super(name, !file.isDirectory());
        this.file = file;
        this.initialize();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void resetContent() {
        this.document = null;
        this.initialize();
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public FileDocument getDocument() {
        if (this.document == null || this.isDocumentOutOfDate()) {
            this.initialize();
            this.document = new FileDocument(this.file);
            this.fileLastModified = this.file.lastModified();
        }
        return this.document;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    private boolean isDocumentOutOfDate() {
        boolean outOfDate;
        if (this.file == null) {
            return false;
        }
        boolean bl = outOfDate = this.file.lastModified() != this.fileLastModified;
        if (outOfDate) {
            System.out.println("FileNode[" + this + "] is out of date [" + this.file.lastModified() + " != " + this.fileLastModified + "]");
        }
        return outOfDate;
    }

    private void initialize() {
        this.exists = this.file.exists();
    }

    public boolean isReadonly() {
        return false;
    }
}

