/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.util.prefs;

import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jmeld.util.prefs.Preference;

public class ComboBoxPreference
extends Preference {
    private static String ITEMS = "ITEMS";
    private JComboBox target;
    private int maxItems = 10;

    public ComboBoxPreference(String preferenceName, JComboBox target) {
        super("ComboBox-" + preferenceName);
        this.target = target;
        this.init();
    }

    private void init() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String item : this.getListOfString(ITEMS, this.maxItems)) {
            model.addElement(item);
        }
        this.target.setModel(model);
        model.addListDataListener(this.getListDataListener());
        if (this.target.getItemCount() > 0) {
            this.target.setSelectedIndex(0);
        }
    }

    private void save() {
        ArrayList<String> list = new ArrayList<String>();
        ComboBoxModel model = this.target.getModel();
        String item = (String)model.getSelectedItem();
        if (item != null) {
            list.add(item);
        }
        for (int i = 0; i < model.getSize(); ++i) {
            item = (String)model.getElementAt(i);
            if (list.contains(item)) continue;
            list.add(item);
        }
        this.putListOfString(ITEMS, this.maxItems, list);
    }

    private ListDataListener getListDataListener() {
        return new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                ComboBoxPreference.this.save();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ComboBoxPreference.this.save();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ComboBoxPreference.this.save();
            }
        };
    }
}

