/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jmeld.vc.VersionControlIF;
import org.jmeld.vc.bzr.BazaarVersionControl;
import org.jmeld.vc.git.GitVersionControl;
import org.jmeld.vc.hg.MercurialVersionControl;
import org.jmeld.vc.svn.SubversionVersionControl;

public class VersionControlUtil {
    private static List<VersionControlIF> versionControlList;

    public static boolean isVersionControlled(File file) {
        return VersionControlUtil.getVersionControl(file) != null;
    }

    public static List<VersionControlIF> getVersionControl(File file) {
        ArrayList<VersionControlIF> list = new ArrayList<VersionControlIF>();
        for (VersionControlIF versionControl : VersionControlUtil.getVersionControlList()) {
            if (!versionControl.isInstalled() || !versionControl.isEnabled(file)) continue;
            list.add(versionControl);
        }
        return list;
    }

    public static List<VersionControlIF> getVersionControlList() {
        if (versionControlList == null) {
            versionControlList = new ArrayList<VersionControlIF>();
            versionControlList.add(new SubversionVersionControl());
            versionControlList.add(new MercurialVersionControl());
            versionControlList.add(new GitVersionControl());
            versionControlList.add(new BazaarVersionControl());
        }
        return versionControlList;
    }

    public static VersionControlIF getFirstVersionControl(File file) {
        versionControlList = VersionControlUtil.getVersionControl(file);
        if (versionControlList.isEmpty()) {
            return null;
        }
        return versionControlList.get(0);
    }
}

