/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.bzr;

import java.io.File;
import java.util.Vector;
import org.jmeld.vc.BaseFile;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.VersionControlIF;
import org.jmeld.vc.bzr.ActiveCmd;
import org.jmeld.vc.bzr.CatCmd;
import org.jmeld.vc.bzr.InstalledCmd;
import org.jmeld.vc.bzr.StatusCmd;

public class BazaarVersionControl
implements VersionControlIF {
    private Boolean installed;
    private String reference;

    public BazaarVersionControl() {
        this.setReference("HEAD");
    }

    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public String getName() {
        return "bazaar";
    }

    @Override
    public boolean isInstalled() {
        if (this.installed == null) {
            InstalledCmd cmd = new InstalledCmd();
            cmd.execute();
            this.installed = cmd.getResult().isTrue();
        }
        return this.installed;
    }

    @Override
    public boolean isEnabled(File file) {
        ActiveCmd cmd = new ActiveCmd(file);
        cmd.execute();
        return cmd.getResult().isTrue();
    }

    @Override
    public StatusResult executeStatus(File file) {
        StatusCmd cmd = new StatusCmd(file);
        cmd.execute();
        return (StatusResult)cmd.getResultData();
    }

    @Override
    public BaseFile getBaseFile(File file) {
        CatCmd cmd = new CatCmd(file);
        cmd.execute();
        return (BaseFile)cmd.getResultData();
    }

    @Override
    public Vector<String> getRevisions(File file) {
        Vector<String> revisions = new Vector<String>();
        revisions.add("HEAD");
        return revisions;
    }

    public String toString() {
        return this.getName();
    }
}

