/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.bzr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jmeld.util.Result;
import org.jmeld.vc.StatusResult;
import org.jmeld.vc.bzr.BazaarVersionControl;
import org.jmeld.vc.util.VcCmd;

public class StatusCmd
extends VcCmd<StatusResult> {
    private File file;
    private Phase phase;

    public StatusCmd(File file) {
        this.file = file;
        this.initWorkingDirectory(file);
    }

    public Result execute() {
        this.phase = Phase.state;
        super.execute("bzr", "status", "-S", this.file.getAbsolutePath());
        this.phase = Phase.inventory;
        super.execute("bzr", "inventory", this.file.getAbsolutePath());
        return this.getResult();
    }

    @Override
    protected void build(byte[] data) {
        StatusResult statusResult = this.phase == Phase.state ? new StatusResult(this.file) : (StatusResult)this.getResultData();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String text;
            while ((text = reader.readLine()) != null) {
                StatusResult.Status status;
                if (this.phase == Phase.state) {
                    if (text.length() < 5) continue;
                    status = null;
                    switch (text.charAt(0)) {
                        case '+': {
                            switch (text.charAt(1)) {
                                case 'K': 
                                case 'M': {
                                    status = StatusResult.Status.modified;
                                    break;
                                }
                                case 'N': {
                                    status = StatusResult.Status.added;
                                    break;
                                }
                                case 'D': {
                                    status = StatusResult.Status.removed;
                                }
                            }
                            break;
                        }
                        case ' ': {
                            switch (text.charAt(1)) {
                                case 'D': {
                                    status = StatusResult.Status.missing;
                                }
                            }
                            break;
                        }
                        case '-': {
                            status = StatusResult.Status.ignored;
                            break;
                        }
                        case '?': {
                            status = StatusResult.Status.unversioned;
                        }
                    }
                    statusResult.addEntry(text.substring(4), status);
                    continue;
                }
                if (this.phase != Phase.inventory) continue;
                status = StatusResult.Status.clean;
                statusResult.addEntry(text, status);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setResultData(statusResult);
    }

    public static void main(String[] args) {
        File file = StatusCmd.parseFile(args);
        if (file == null) {
            return;
        }
        StatusResult result = new BazaarVersionControl().executeStatus(file);
        if (result != null) {
            for (StatusResult.Entry entry : result.getEntryList()) {
                System.out.println(entry.getStatus().getShortText() + " " + entry.getName());
            }
        }
    }

    private static enum Phase {
        state,
        inventory;

    }
}

