/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.vc.git;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jmeld.util.Result;
import org.jmeld.vc.git.BranchData;
import org.jmeld.vc.util.VcCmd;

public class BranchCmd
extends VcCmd<BranchData> {
    private File file;

    public BranchCmd(File file) {
        this.file = file;
        this.initWorkingDirectory(file);
    }

    public Result execute() {
        super.execute("git", "branch");
        return this.getResult();
    }

    @Override
    protected void build(byte[] data) {
        BranchData branchData = new BranchData();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        try {
            String text;
            while ((text = reader.readLine()) != null) {
                String branch = text.substring(2);
                branchData.add(branch);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setResultData(branchData);
    }

    public static void main(String[] args) {
        File file = BranchCmd.parseFile(args);
        if (file == null) {
            return;
        }
        BranchCmd cmd = new BranchCmd(file);
        if (cmd.execute().isTrue()) {
            for (String branch : ((BranchData)cmd.getResultData()).getBranchs()) {
                System.out.println(branch);
            }
        } else {
            cmd.printError();
        }
    }
}

